/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

public enum LegacyAuthType {
    BUILTIN(1, "built-in"),
    LDAP(2, "LDAP"),
    HOST(3, "host"),
    CUSTOM(4, "custom"),
    AJP(5, "ajp"),
    CROWD(6, "crowd");

    private final int key;
    private final String displayName;

    private LegacyAuthType(int key, String displayName) {
        this.key = key;
        this.displayName = displayName;
    }

    public int getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static LegacyAuthType fromKey(int key) {
        for (LegacyAuthType type : LegacyAuthType.values()) {
            if (type.getKey() != key) continue;
            return type;
        }
        throw new IllegalArgumentException(key + "is an invalid key for AuthType");
    }

    public static LegacyAuthType fromDisplayNameIgnoreCase(String displayName) {
        for (LegacyAuthType authType : LegacyAuthType.values()) {
            if (!authType.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return authType;
        }
        throw new IllegalArgumentException(String.format("Type: %s not supported.", displayName));
    }
}

