/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTask;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.filters.SimpleMessage;
import com.cenqua.fisheye.web.filters.SystemMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmbeddedCrowdUpgradeTaskWarningMessageSource
implements MessageSource {
    private static final Logger log = Logs.loggerFor(EmbeddedCrowdUpgradeTaskWarningMessageSource.class);
    @VisibleForTesting
    static final String DISMISS_PROPERTY_NAME = "com.atlassian.fecru.properties.dialogDismissed.embeddedCrowd4.0UpgradeTaskWarning";
    private final RepositoryPropertyManager propertyManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final Path logFilePath;
    private boolean warningsFoundInLogs;
    private boolean upgradeTaskLogFileExists;

    @Autowired
    public EmbeddedCrowdUpgradeTaskWarningMessageSource(EffectiveUserProvider effectiveUserProvider, RepositoryPropertyManager propertyManager) {
        this(effectiveUserProvider, propertyManager, Paths.get(EmbeddedCrowdUpgradeTask.getLogFileName(), new String[0]));
    }

    @VisibleForTesting
    EmbeddedCrowdUpgradeTaskWarningMessageSource(EffectiveUserProvider effectiveUserProvider, RepositoryPropertyManager propertyManager, Path logFilePath) {
        this.propertyManager = propertyManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.logFilePath = logFilePath;
    }

    @PostConstruct
    @VisibleForTesting
    void grepLogForWarnings() throws IOException {
        this.upgradeTaskLogFileExists = Files.exists(this.logFilePath, new LinkOption[0]);
        if (this.upgradeTaskLogFileExists) {
            try (Stream<String> logFileStream = Files.lines(this.logFilePath, Charset.defaultCharset());){
                this.warningsFoundInLogs = logFileStream.anyMatch(line -> line.contains(" WARN ") || line.contains(" ERROR "));
            }
            catch (Exception e2) {
                log.warn((Object)("Failed to parse " + this.logFilePath + ", assuming there have been some warnings or errors in the log"), (Throwable)e2);
                this.warningsFoundInLogs = true;
            }
        }
    }

    @Override
    public List<SystemMessage> getMessages(HttpServletRequest request) {
        if (this.upgradeTaskLogFileExists && this.effectiveUserProvider.isAdmin() && !this.isDismissed()) {
            if (this.warningsFoundInLogs) {
                return EmbeddedCrowdUpgradeTaskWarningMessageSource.newSimpleMessage("User data upgrade experienced problems. Please review WARN/ERROR logs in " + this.logFilePath + ".");
            }
            return EmbeddedCrowdUpgradeTaskWarningMessageSource.newSimpleMessage("User data has been successfully upgraded. Please review details in " + this.logFilePath + ".");
        }
        return ImmutableList.of();
    }

    private static ImmutableList<SystemMessage> newSimpleMessage(String message) {
        return ImmutableList.of((Object)new SimpleMessage(message, HelpUtil.getFishEyeHelpPath("fisheye.upgrade.notes.4.0"), true, SimpleMessage.ShowIn.HEADER, Optional.of(DISMISS_PROPERTY_NAME)));
    }

    private boolean isDismissed() {
        return Boolean.valueOf(this.propertyManager.loadGlobalProperty(DISMISS_PROPERTY_NAME));
    }
}

