/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.logging.log4j.NewLineIndentingFilteringPatternLayout;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateAuthenticationConfigurations;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateGroupMembershipsToCwdMemberships;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateGroupsToCwdGroups;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateUserLicenses;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateUsersToCwdUsers;
import com.cenqua.crucible.hibernate.upgrade.crowd.MoveDataFromCruUser;
import com.cenqua.crucible.hibernate.upgrade.crowd.RepositoryExternalPermissionCleanUpTask;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EmbeddedCrowdUpgradeTask
implements UpgradeTask {
    private static final Logger log = Logs.loggerFor(EmbeddedCrowdUpgradeTask.class);
    static final int APPLICATION_ID = 1;
    static final int INTERNAL_DIRECTORY_ID = 1;
    static final int APPLICATION_INTERNAL_DIRECTORY_MAPPING_ID = 1;
    private Level previousLogLevel;
    private FileAppender embeddedCrowdFileAppender;

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        try {
            NewLineIndentingFilteringPatternLayout layout = new NewLineIndentingFilteringPatternLayout();
            layout.setConversionPattern("%d{ISO8601} %-5p [%t %.20x] %C{1}-%M - %m\n");
            this.embeddedCrowdFileAppender = new FileAppender((Layout)layout, EmbeddedCrowdUpgradeTask.getLogFileName());
            log.addAppender((Appender)this.embeddedCrowdFileAppender);
        }
        catch (IOException e2) {
            log.warn((Object)"Failed to create a custom file appender, will log only to standard appenders", (Throwable)e2);
        }
        this.previousLogLevel = log.getLevel();
        log.setLevel(Level.DEBUG);
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
        this.resetLogChanges();
    }

    public void resetLogChanges() {
        log.setLevel(this.previousLogLevel);
        log.removeAppender((Appender)this.embeddedCrowdFileAppender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        try {
            log.info((Object)"Starting EmbeddedCrowdUpgradeTask.afterUpgradeScript");
            MigrateAuthenticationConfigurations authenticationConfigurationsMigration = new MigrateAuthenticationConfigurations(conn, log);
            authenticationConfigurationsMigration.perform();
            Optional<Integer> ldapDirectoryId = this.getDirectoryId(conn, "CONNECTOR");
            new MoveDataFromCruUser(conn, log).execute();
            MigrateUsersToCwdUsers userMigration = new MigrateUsersToCwdUsers(conn, log, ldapDirectoryId);
            userMigration.perform();
            MigrateGroupsToCwdGroups groupsMigration = new MigrateGroupsToCwdGroups(conn, log, ldapDirectoryId);
            groupsMigration.perform();
            MigrateGroupMembershipsToCwdMemberships membershipsMigration = new MigrateGroupMembershipsToCwdMemberships(conn, log, userMigration.getMigratedUsersData(), groupsMigration.getMigratedGroups());
            membershipsMigration.perform();
            new MigrateUserLicenses(conn, log, ldapDirectoryId, this.getDirectoryId(conn, "CROWD")).perform();
            this.upgradeConfigXml();
            this.removeOldTablesAndColumns(conn);
            authenticationConfigurationsMigration.cleanupSecurityConfigXml();
            log.info((Object)"Done EmbeddedCrowdUpgradeTask.afterUpgradeScript");
        }
        finally {
            this.resetLogChanges();
        }
    }

    private void upgradeConfigXml() {
        try {
            RepositoryExternalPermissionCleanUpTask repositoryExternalPermissionCleanUpTask = new RepositoryExternalPermissionCleanUpTask(log);
            repositoryExternalPermissionCleanUpTask.perform();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        CrowdUpgradeUtil.getSecurityConfig().ifPresent(security -> {
            if (security.isSetUsernames()) {
                security.unsetUsernames();
                CrowdUpgradeUtil.saveConfig();
            }
        });
    }

    /*
     * Exception decompiling
     */
    private Optional<Integer> getDirectoryId(Connection conn, String directoryTYpe) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeOldTablesAndColumns(Connection conn) throws SQLException {
        log.info((Object)"Removing obsolete tables");
        try (Statement removeTablesStatement = conn.createStatement();){
            log.debug((Object)"Removing CRU_BUILTIN_GROUP_USER table");
            removeTablesStatement.executeUpdate("DROP TABLE cru_builtin_group_user");
            log.debug((Object)"Removing CRU_BUILTIN_GROUP table");
            removeTablesStatement.executeUpdate("DROP TABLE cru_builtin_group");
            log.debug((Object)"Removing CRU_USER columns");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_authtype");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_crucible_enabled");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_fisheye_enabled");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_displayname");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_email");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_passwordhash");
            removeTablesStatement.executeUpdate("ALTER TABLE cru_user DROP COLUMN cru_timezone");
        }
    }

    @VisibleForTesting
    static String getLogFileName() {
        return AppConfig.getLogDir().getPath().concat("/atlassian-fisheye-").concat(EmbeddedCrowdUpgradeTask.class.getSimpleName()).concat(".log");
    }
}

