/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.config1.SystemAdmins;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

class CrowdUpgradeUtil {
    static final Function<String, String> NORMALIZE_GROUP = UserManager.GROUPNAME_NORMALIZATION;
    static final Function<String, String> NORMALIZE_USER = UserManager.USERNAME_NORMALIZATION;
    static final String INSERT_CWD_MEMBERSHIP = "INSERT INTO cwd_membership (id, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    CrowdUpgradeUtil() {
    }

    /*
     * Exception decompiling
     */
    static int countRows(Connection conn, String table, String whereClause, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String generateNewName(String originalName, Predicate<String> isUnique) {
        int idx = 1;
        do {
            String newName;
            if (!isUnique.test(newName = originalName + "_migration" + idx++)) continue;
            return newName;
        } while (idx < 1000000000);
        throw new IllegalStateException("Couldn't find a valid name to rename " + originalName + " to. Aborting.");
    }

    static void executeUpdate(Connection conn, String sql, Object ... params) {
        try (PreparedStatement update = conn.prepareStatement(sql);){
            int idx = 1;
            for (Object param : params) {
                update.setObject(idx++, param);
            }
            update.executeUpdate();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    static void updateSysAdmins(Consumer<SystemAdmins> adminMutator) {
        ConfigDocument.Config configDoc = AppConfig.getsConfig().getConfig();
        if (configDoc.isSetSecurity() && configDoc.getSecurity().isSetAdmins() && configDoc.getSecurity().getAdmins().isSetSystemAdmins()) {
            SystemAdmins admins = configDoc.getSecurity().getAdmins().getSystemAdmins();
            adminMutator.accept(admins);
        }
        CrowdUpgradeUtil.saveConfig();
    }

    static void saveConfig() {
        try {
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new RuntimeException("Error saving config file", e2);
        }
    }

    static void addCrowdGroup(Connection conn, int cwdGroupId, Date migrationDate, String groupName, int directoryId) {
        try (PreparedStatement addGroup = conn.prepareStatement("INSERT INTO cwd_group (id, group_name, lower_group_name, active, is_local, created_date, updated_date, group_type, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            addGroup.setInt(1, cwdGroupId);
            addGroup.setString(2, groupName);
            addGroup.setString(3, NORMALIZE_GROUP.apply(groupName));
            addGroup.setString(4, "T");
            addGroup.setString(5, directoryId == 1 ? "F" : "T");
            addGroup.setDate(6, migrationDate);
            addGroup.setDate(7, migrationDate);
            addGroup.setString(8, "GROUP");
            addGroup.setInt(9, directoryId);
            addGroup.execute();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    static void addGroupMembershipBatch(PreparedStatement addMembershipStatement, int id, int userId, String username, int groupId, String groupName, int directoryId) throws SQLException {
        addMembershipStatement.setInt(1, id);
        addMembershipStatement.setInt(2, groupId);
        addMembershipStatement.setInt(3, userId);
        addMembershipStatement.setString(4, "GROUP_USER");
        addMembershipStatement.setString(5, "GROUP");
        addMembershipStatement.setString(6, groupName);
        addMembershipStatement.setString(7, NORMALIZE_GROUP.apply(groupName));
        addMembershipStatement.setString(8, username);
        addMembershipStatement.setString(9, NORMALIZE_USER.apply(username));
        addMembershipStatement.setInt(10, directoryId);
        addMembershipStatement.addBatch();
    }

    static Optional<SecurityType> getSecurityConfig() {
        ConfigDocument.Config configDoc = AppConfig.getsConfig().getConfig();
        if (!configDoc.isSetSecurity()) {
            return Optional.empty();
        }
        return Optional.of(configDoc.getSecurity());
    }
}

