/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.DB0HandleUtil;
import com.cenqua.crucible.hibernate.upgrade.DB0Watch;
import com.cenqua.crucible.hibernate.upgrade.UpgradeDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeUserIdResolver;
import com.cenqua.crucible.hibernate.upgrade.WatchEAV;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class WatchMigrationUpgradeTask
implements UpgradeTask {
    private static final String INSERT_WATCH = "insert into cru_watch (cru_watch_id,cru_user_id,cru_repository_name,cru_path,cru_constraint,cru_last_checked,cru_last_revision_path,cru_last_revision_rev,cru_csn_last_revision,cru_watch_key) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_WATCH = "delete from cru_watch";
    private final DB0HandleFactory db0HandleFactory;

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    public WatchMigrationUpgradeTask(DB0HandleFactory db0HandleFactory) {
        this.db0HandleFactory = db0HandleFactory;
    }

    public WatchMigrationUpgradeTask() {
        this(new UpgradeDB0HandleFactory());
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        Preconditions.checkArgument((boolean)conn.getAutoCommit());
        Logs.APP_LOG.info((Object)"[data0.bin] Migrating watches from data0.bin to SQL database.");
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        WatchMigrationUpgradeTask.sqlDeleteWatches(conn);
        DB0Handle db0Handle = null;
        try {
            db0Handle = this.db0HandleFactory.getInstance();
            UpgradeUserIdResolver userIdResolver = new UpgradeUserIdResolver(conn);
            List<DB0Watch> watchesWithDups = WatchMigrationUpgradeTask.findWatches(db0Handle);
            List<DB0Watch> watches = WatchMigrationUpgradeTask.deduplicate(watchesWithDups);
            int count = 0;
            for (DB0Watch watch : watches) {
                Integer userId = userIdResolver.resolve(watch.getUsername());
                if (userId == null) {
                    Logs.APP_LOG.warn((Object)String.format("[data0.bin] Ignoring watch for user %s. User is not present in the user table: %s", watch.getUsername(), watch));
                    continue;
                }
                try {
                    WatchMigrationUpgradeTask.sqlInsertWatch(conn, watch, userId);
                    ++count;
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)String.format("[data0.bin] Error when inserting watch: %s, %s", watch, e2.getMessage()));
                }
            }
            stopwatch.stop();
            Logs.APP_LOG.info((Object)String.format("[data0.bin] Migrated %d from %d watches in %s.", count, watchesWithDups.size(), stopwatch.toString()));
        }
        catch (Exception e3) {
            throw new IllegalStateException("Error during watch migration", e3);
        }
        finally {
            DB0HandleUtil.close(db0Handle);
        }
    }

    private static List<DB0Watch> findWatches(DB0Handle db0Handle) {
        return db0Handle.read(new DB0Handle.Reader<List<DB0Watch>>(){

            @Override
            public List<DB0Watch> read(InfinityDbHandle db) throws DbException {
                ArrayList watches = Lists.newArrayList();
                WatchEAV watchEAV = new WatchEAV(db);
                Set<String> repoNames = watchEAV.getRepoNames();
                for (String repoName : repoNames) {
                    watches.addAll(watchEAV.getWatchesForRep(repoName));
                }
                return watches;
            }
        });
    }

    private static List<DB0Watch> deduplicate(List<DB0Watch> watchesWithDups) {
        HashMap watchesByKey = Maps.newHashMap();
        for (DB0Watch watch : watchesWithDups) {
            if (watch.getWatchKey() == null) {
                Logs.APP_LOG.warn((Object)String.format("Watch has no unique key. Skipping this watch: %s", watch));
                continue;
            }
            DB0Watch previous = watchesByKey.put(watch.getWatchKey(), watch);
            if (previous == null) continue;
            Logs.APP_LOG.warn((Object)String.format("[data0.bin] A duplicated watch will be ignored: %s", previous));
        }
        return ImmutableList.copyOf(watchesByKey.values());
    }

    private static void sqlDeleteWatches(Connection conn) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(DELETE_WATCH);
            statement.executeUpdate();
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not clean watch table", e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private static void sqlInsertWatch(Connection conn, DB0Watch watch, Integer userId) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_WATCH);
            statement.setLong(1, watch.getId());
            statement.setInt(2, userId);
            statement.setString(3, watch.getRep());
            statement.setString(4, watch.getPath());
            statement.setString(5, watch.getConstraintAsCommandString());
            statement.setLong(6, watch.getLastChecked());
            statement.setString(7, watch.getLastRevisionSent() != null ? watch.getLastRevisionSent().getPathAsString() : null);
            statement.setString(8, watch.getLastRevisionSent() != null ? watch.getLastRevisionSent().getRev() : null);
            statement.setLong(9, watch.getCacheSerialOfLastRevisionSent());
            statement.setString(10, watch.getWatchKey());
            if (statement.executeUpdate() == 0) {
                throw new IllegalStateException(String.format("Watch (%s) could not be created", watch));
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Could not migrate watch: %s", watch), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

