/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserProfile;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.FEUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

final class UserValidatorUtils {
    UserValidatorUtils() {
    }

    static boolean validate(FEUser user, LegacyUserProfile profile, String username) {
        ArrayList<String> errors = new ArrayList<String>();
        UserValidatorUtils.validateUser(user, errors);
        UserValidatorUtils.validateProfile(profile, errors);
        boolean isValid = errors.isEmpty();
        if (!isValid) {
            Logs.APP_LOG.error((Object)("User " + username + " could not be migrated because of the following errors: "));
            Logs.APP_LOG.error(errors);
        }
        return isValid;
    }

    private static void validateUser(FEUser user, List<String> errors) {
        user.setUsername(StringUtils.abbreviate((String)user.getUsername(), (int)255));
        user.setEmail(StringUtils.abbreviate((String)user.getEmail(), (int)255));
        user.setPasswordHash(UserValidatorUtils.nullIfAbove(user.getPasswordHash(), 255));
        user.setDisplayName(StringUtils.abbreviate((String)user.getDisplayName(), (int)255));
        user.setPasswordResetSRnd(UserValidatorUtils.nullIfAbove(user.getPasswordResetSRnd(), 255));
        user.setDisplayName(StringUtils.defaultIfEmpty((String)user.getDisplayName(), (String)user.getUsername()));
        user.setEmail(StringUtils.stripToNull((String)user.getEmail()));
        if (StringUtils.isBlank((String)user.getUsername())) {
            errors.add("No user name");
        }
        if (user.getAuthType() == null) {
            errors.add("Unknown authentication provider (Built-in, LDAP, Crowd, etc.)");
        }
    }

    private static void validateProfile(LegacyUserProfile profile, List<String> errors) {
        profile.setTimezone(UserValidatorUtils.nullIfAbove(profile.getTimezone(), 255));
        profile.setCookiePrefs(UserValidatorUtils.nullIfAbove(profile.getCookiePrefs(), 4096));
        profile.setUploadType(UserValidatorUtils.nullIfAbove(profile.getUploadType(), 255));
        profile.setUploadMethod(UserValidatorUtils.nullIfAbove(profile.getUploadMethod(), 255));
        profile.setUploadCharset(UserValidatorUtils.nullIfAbove(profile.getUploadCharset(), 255));
    }

    private static String nullIfAbove(String s2, int max) {
        return s2 != null && s2.length() > max ? null : s2;
    }
}

