/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeConfig;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UserValidatorUtils;
import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserManager;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserProfile;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class UserMigrationUpgradeTask
implements UpgradeTask {
    private static final String CHECK_USER_EXISTS = "SELECT cru_user_id FROM cru_user where cru_user_name = ?";
    private static final String START_SEQ_NUMBER = "select max(cru_user_id) from cru_user";
    private static final String INSERT_USER = "INSERT INTO cru_user (cru_user_id, cru_user_name, cru_fisheye_enabled, cru_crucible_enabled, cru_email, cru_passwordhash, cru_authtype, cru_timezone,  cru_displayname, cru_passwordreset_srnd, cru_passwordresettimestamp, cru_failedlogincount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_USER = "UPDATE cru_user SET cru_fisheye_enabled = ?, cru_crucible_enabled = ?, cru_email= ?, cru_passwordhash = ?, cru_authtype = ?, cru_timezone = ?,  cru_displayname = ?, cru_passwordreset_srnd = ?, cru_passwordresettimestamp = ?, cru_failedlogincount = ? WHERE cru_user_name = ?";
    public static final String INSERT_USER_PROFILE = "INSERT INTO cru_user_profile (cru_user_id, cru_tabwidth, cru_cookieprefs, cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_USER_PROFILE = "UPDATE cru_user_profile SET cru_tabwidth = ?, cru_cookieprefs = ?, cru_watchmode = ?, cru_emailformat = ?, cru_changesetsperpage = ?, cru_maxfilesperchangeset = ?, cru_ideconnectorport = ?, cru_enableide = ?, cru_context = ?, cru_upload_type = ?, cru_upload_method = ?, cru_upload_charset = ?, cru_auto_mark_files = ? WHERE cru_user_id = ?";

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        DB0Handle source = null;
        try {
            source = this.getSourceDb();
            new LegacyUserManager(source);
            this.migrateUsers(source, conn);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Error during the migration of the users from IDB", e2);
        }
        finally {
            this.close(source);
        }
    }

    private void close(DB0Handle source) {
        try {
            if (source != null) {
                source.close();
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error while closing InfinityDB after migration", (Throwable)e2);
        }
    }

    protected DB0Handle getSourceDb() throws IOException {
        if (!UpgradeConfig.INSTANCE.isDBopen()) {
            this.openInfinityDB();
        }
        return UpgradeConfig.INSTANCE.getDB0Handle();
    }

    private void openInfinityDB() {
        try {
            UpgradeConfig.INSTANCE.startDB();
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not start IDB", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxUserId(Connection conn) throws SQLException {
        ResultSet resultSet;
        PreparedStatement statement;
        block3: {
            int n2;
            statement = null;
            resultSet = null;
            try {
                statement = conn.prepareStatement(START_SEQ_NUMBER);
                statement.setFetchSize(1);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block3;
                n2 = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                JDBCHelper.closeQuietly(resultSet, statement);
                throw throwable;
            }
            JDBCHelper.closeQuietly(resultSet, statement);
            return n2;
        }
        int n3 = 0;
        JDBCHelper.closeQuietly(resultSet, statement);
        return n3;
    }

    private void migrateUsers(DB0Handle db0Handle, Connection conn) throws DbException, IOException, SQLException {
        List<String> usernames = this.listUsernames(db0Handle);
        int sequence = this.getMaxUserId(conn) + 1;
        for (String username : usernames) {
            LegacyUserProfile userProfile;
            FEUser user = this.getUser(db0Handle, username);
            if (!UserValidatorUtils.validate(user, userProfile = this.getUserProfile(db0Handle, username), username)) continue;
            Integer userId = this.userExistsInDB(conn, username);
            if (userId != null) {
                this.updateUser(conn, user, userProfile);
                this.updateUserProfile(conn, userProfile, userId);
                continue;
            }
            this.insertUser(conn, user, userProfile, sequence);
            this.insertUserProfile(conn, user, userProfile, sequence);
            ++sequence;
        }
    }

    private List<String> listUsernames(DB0Handle db0Handle) throws DbException {
        return db0Handle.read(new DB0Handle.Reader<List<String>>(){

            @Override
            public List<String> read(InfinityDbHandle db) throws DbException {
                FEUserEAV ueav = new FEUserEAV(db);
                return ueav.listAllUserNames();
            }
        });
    }

    private FEUser getUser(DB0Handle dbHandle, final String username) {
        return dbHandle.read(new DB0Handle.Reader<FEUser>(){

            @Override
            public FEUser read(InfinityDbHandle db) throws DbException {
                FEUserEAV ueav = new FEUserEAV(db);
                return ueav.load(username);
            }
        });
    }

    private LegacyUserProfile getUserProfile(DB0Handle dbHandle, final String username) {
        return dbHandle.read(new DB0Handle.Reader<LegacyUserProfile>(){

            @Override
            public LegacyUserProfile read(InfinityDbHandle db) throws DbException {
                FEUserEAV ueav = new FEUserEAV(db);
                return ueav.loadProfile(username);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer userExistsInDB(Connection conn, String username) throws SQLException {
        Integer n2;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(CHECK_USER_EXISTS);
            statement.setFetchSize(1);
            statement.setString(1, username);
            resultSet = statement.executeQuery();
            n2 = resultSet.next() ? Integer.valueOf(resultSet.getInt(1)) : null;
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly(resultSet, statement);
        return n2;
    }

    private void insertUser(Connection conn, FEUser user, LegacyUserProfile userProfile, int currentSequence) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_USER);
            statement.setInt(1, currentSequence);
            statement.setString(2, user.getUsername());
            statement.setBoolean(3, true);
            statement.setBoolean(4, user.isCrucibleEnabled());
            statement.setString(5, user.getEmail());
            statement.setString(6, user.getPasswordHash());
            statement.setInt(7, user.getAuthType().getKey());
            statement.setString(8, userProfile.getTimezone());
            statement.setString(9, user.getDisplayName());
            statement.setString(10, user.getPasswordResetSRnd());
            statement.setLong(11, user.getPasswordResetTimeStamp());
            statement.setLong(12, user.getFailedLoginAttempts());
            int created = statement.executeUpdate();
            if (created == 0) {
                throw new IllegalStateException("User " + user.getUsername() + " could not be created");
            }
        }
        catch (SQLException e2) {
            throw new IllegalStateException("Could not migrate user: " + user.getUsername(), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private void insertUserProfile(Connection conn, FEUser user, LegacyUserProfile userProfile, Integer userId) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_USER_PROFILE);
            statement.setInt(1, userId);
            statement.setInt(2, userProfile.getTabwidth());
            statement.setString(3, userProfile.getCookiePrefs());
            statement.setInt(4, userProfile.getWatchMode());
            statement.setInt(5, userProfile.getEmailFormat());
            statement.setInt(6, userProfile.getChangesetsPerPage());
            statement.setInt(7, userProfile.getMaxFilesPerChangeset());
            statement.setInt(8, userProfile.getIdeConnectorPort());
            statement.setBoolean(9, userProfile.isEnableIde());
            statement.setInt(10, userProfile.getContext());
            statement.setString(11, userProfile.getUploadType());
            statement.setString(12, userProfile.getUploadMethod());
            statement.setString(13, userProfile.getUploadCharset());
            statement.setBoolean(14, userProfile.isAutoMarkFilesRead());
            statement.setBoolean(15, true);
            statement.setInt(16, 1);
            statement.setInt(17, 1);
            statement.setInt(18, 1);
            statement.setInt(19, 1);
            statement.setInt(20, 1);
            statement.setInt(21, 2);
            statement.setBoolean(22, true);
            statement.setBoolean(23, true);
            int created = statement.executeUpdate();
            if (created == 0) {
                throw new IllegalStateException("User profile " + userProfile.getUsername() + " could not be created");
            }
        }
        catch (SQLException e2) {
            throw new IllegalStateException("Could not migrate user: " + userProfile.getUsername(), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private void updateUser(Connection conn, FEUser user, LegacyUserProfile userProfile) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(UPDATE_USER);
            statement.setBoolean(1, true);
            statement.setBoolean(2, user.isCrucibleEnabled());
            statement.setString(3, user.getEmail());
            statement.setString(4, user.getPasswordHash());
            statement.setInt(5, user.getAuthType().getKey());
            statement.setString(6, userProfile.getTimezone());
            statement.setString(7, user.getDisplayName());
            statement.setString(8, user.getPasswordResetSRnd());
            statement.setLong(9, user.getPasswordResetTimeStamp());
            statement.setLong(10, user.getFailedLoginAttempts());
            statement.setString(11, user.getUsername());
            int updated = statement.executeUpdate();
            if (updated == 0) {
                throw new IllegalStateException("User " + user.getUsername() + " could not be updated");
            }
        }
        catch (SQLException e2) {
            throw new IllegalStateException("Could not migrate user: " + user.getUsername(), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private void updateUserProfile(Connection conn, LegacyUserProfile userProfile, Integer userId) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(UPDATE_USER_PROFILE);
            statement.setInt(1, userProfile.getTabwidth());
            statement.setString(2, userProfile.getCookiePrefs());
            statement.setInt(3, userProfile.getWatchMode());
            statement.setInt(4, userProfile.getEmailFormat());
            statement.setInt(5, userProfile.getChangesetsPerPage());
            statement.setInt(6, userProfile.getMaxFilesPerChangeset());
            statement.setInt(7, userProfile.getIdeConnectorPort());
            statement.setBoolean(8, userProfile.isEnableIde());
            statement.setInt(9, userProfile.getContext());
            statement.setString(10, userProfile.getUploadType());
            statement.setString(11, userProfile.getUploadMethod());
            statement.setString(12, userProfile.getUploadCharset());
            statement.setBoolean(13, userProfile.isAutoMarkFilesRead());
            statement.setInt(14, userId);
            int created = statement.executeUpdate();
            if (created == 0) {
                throw new IllegalStateException("User profile " + userProfile.getUsername() + " could not be updated");
            }
        }
        catch (SQLException e2) {
            throw new IllegalStateException("Could not migrate user: " + userProfile.getUsername(), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

