/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.DbUtils;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationDefaults;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class UserMigrationSetDefaultsTask
implements UpgradeTask {
    public static final String UPDATE_NULL_COLUMN = "update %1$s set %2$s = %3$s where %2$s is null";
    protected boolean supportBooleanKeywords = true;

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException {
        this.supportBooleanKeywords = DbUtils.supportBoolean(conn);
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        this.replaceNullValue(conn, "cru_user", "cru_fisheye_enabled", UserMigrationDefaults.fisheyeEnabled);
        this.replaceNullValue(conn, "cru_user", "cru_crucible_enabled", UserMigrationDefaults.crucibleEnabled);
        this.replaceNullValue(conn, "cru_user", "cru_authtype", UserMigrationDefaults.authType);
        this.replaceNullValue(conn, "cru_user", "cru_passwordresettimestamp", UserMigrationDefaults.passwordresettimestamp);
        this.replaceNullValue(conn, "cru_user", "cru_failedlogincount", UserMigrationDefaults.failedlogincount);
        this.replace(conn, "cru_user", "cru_displayname", "cru_user_name");
        this.replaceNullValue(conn, "cru_user_profile", "cru_tabwidth", 8);
        this.replaceNullValue(conn, "cru_user_profile", "cru_watchmode", 0);
        this.replaceNullValue(conn, "cru_user_profile", "cru_emailformat", 1);
        this.replaceNullValue(conn, "cru_user_profile", "cru_changesetsperpage", 30);
        this.replaceNullValue(conn, "cru_user_profile", "cru_maxfilesperchangeset", 5);
        this.replaceNullValue(conn, "cru_user_profile", "cru_ideconnectorport", 51235);
        this.replaceNullValue(conn, "cru_user_profile", "cru_enableide", true);
        this.replaceNullValue(conn, "cru_user_profile", "cru_context", 3);
        this.replaceNullValue(conn, "cru_user_profile", "cru_upload_type", "patch");
        this.replaceNullValue(conn, "cru_user_profile", "cru_upload_method", "file");
        this.replaceNullValue(conn, "cru_user_profile", "cru_upload_charset", UserMigrationDefaults.uploadCharset);
        this.replaceNullValue(conn, "cru_user_profile", "cru_auto_mark_files", true);
    }

    private void replaceNullValue(Connection conn, String table, String column, Object defaultValue) {
        this.replace(conn, table, column, this.format(defaultValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(Connection conn, String table, String column, String replacingColumn) {
        PreparedStatement statement = null;
        try {
            String query = String.format(UPDATE_NULL_COLUMN, table, column, replacingColumn);
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            JDBCHelper.closeQuietly(statement);
        }
        catch (SQLException e2) {
            Logs.APP_LOG.error((Object)("Error setting default for column " + column));
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private String format(Object defaultValue) {
        if (defaultValue instanceof String) {
            return "'" + defaultValue + "'";
        }
        if (defaultValue instanceof Boolean && !this.supportBooleanKeywords) {
            return (Boolean)defaultValue != false ? "1" : "0";
        }
        return String.valueOf(defaultValue);
    }
}

