/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.UpgradeConfig;
import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class UpgradeUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUserMaps(Connection conn, final Map<String, Integer> userNames, final Map<String, Integer> displayNames) throws SQLException, DbException, IOException {
        PreparedStatement psSelect = conn.prepareStatement("Select cru_user_id, cru_user_name from cru_user");
        ResultSet userSet = null;
        try {
            userSet = psSelect.executeQuery();
            while (userSet.next()) {
                int id = userSet.getInt(1);
                String username = userSet.getString(2);
                userNames.put(username, id);
            }
        }
        finally {
            JDBCHelper.closeQuietly(userSet, psSelect);
        }
        boolean needsClose = false;
        DB0Handle dbHandle = UpgradeConfig.INSTANCE.getDB0Handle();
        if (dbHandle == null) {
            dbHandle = new DB0Handle(UpgradeConfig.getData0File());
            needsClose = true;
        }
        dbHandle.read(new DB0Handle.Reader<Boolean>(){

            @Override
            public Boolean read(InfinityDbHandle db) throws DbException {
                FEUserEAV eav = new FEUserEAV(db);
                for (Map.Entry e2 : userNames.entrySet()) {
                    FEUser user = eav.load((String)e2.getKey());
                    if (user == null) continue;
                    displayNames.put(user.getDisplayName(), e2.getValue());
                }
                return true;
            }
        });
        if (needsClose) {
            dbHandle.close();
        }
    }
}

