/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.BumpDbVersionUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.CachedTablesUpgrade;
import com.cenqua.crucible.hibernate.upgrade.CommentReadStatusUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.CommitNotificationMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.DedupeStoredPathUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.GroupMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.Hibernate4UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.LogTableUpgradeTask51;
import com.cenqua.crucible.hibernate.upgrade.LogTableUpgradeTask56;
import com.cenqua.crucible.hibernate.upgrade.LoginCookieMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.MissingStoredPathConstraintUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.ProjectKeyUpperCaseUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.SalPropertiesUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.StoredPathHashingTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UserMappingUpgrader;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationSetDefaultsTask;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.WatchMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTask;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpgradeTaskManager {
    private static Int2ObjectMap<List<UpgradeTask>> tasksmap = new Int2ObjectOpenHashMap();

    public static void addTask(int fromversion, UpgradeTask task) {
        ArrayList<UpgradeTask> tasks = (ArrayList<UpgradeTask>)tasksmap.get(fromversion);
        if (tasks == null) {
            tasks = new ArrayList<UpgradeTask>();
            tasksmap.put(fromversion, tasks);
        }
        tasks.add(task);
    }

    public static UpgradeTask findUpgradeTasks(int currentVersion) {
        BumpDbVersionUpgradeTask bumpDbVersionUpgradeTask = new BumpDbVersionUpgradeTask(currentVersion);
        List tasks = (List)tasksmap.get(currentVersion);
        if (tasks == null) {
            return bumpDbVersionUpgradeTask;
        }
        tasks = Lists.newLinkedList((Iterable)tasks);
        tasks.add(bumpDbVersionUpgradeTask);
        return new ChainedUpgradeTask(tasks);
    }

    static {
        UpgradeTaskManager.addTask(28, new CachedTablesUpgrade());
        UpgradeTaskManager.addTask(29, new UserMappingUpgrader());
        UpgradeTaskManager.addTask(51, new LogTableUpgradeTask51());
        UpgradeTaskManager.addTask(56, new LogTableUpgradeTask56());
        UpgradeTaskManager.addTask(61, new CommentReadStatusUpgradeTask());
        UpgradeTaskManager.addTask(73, new UserMigrationUpgradeTask());
        UpgradeTaskManager.addTask(73, new UserMigrationSetDefaultsTask());
        UpgradeTaskManager.addTask(81, new DedupeStoredPathUpgradeTask());
        UpgradeTaskManager.addTask(81, new StoredPathHashingTask());
        UpgradeTaskManager.addTask(84, new DedupeStoredPathUpgradeTask());
        UpgradeTaskManager.addTask(84, new MissingStoredPathConstraintUpgradeTask());
        UpgradeTaskManager.addTask(85, new SalPropertiesUpgradeTask());
        UpgradeTaskManager.addTask(86, new GroupMigrationUpgradeTask());
        UpgradeTaskManager.addTask(86, new LoginCookieMigrationUpgradeTask());
        UpgradeTaskManager.addTask(86, new WatchMigrationUpgradeTask());
        UpgradeTaskManager.addTask(86, new CommitNotificationMigrationUpgradeTask());
        UpgradeTaskManager.addTask(90, new ProjectKeyUpperCaseUpgradeTask());
        UpgradeTaskManager.addTask(91, new Hibernate4UpgradeTask());
        UpgradeTaskManager.addTask(92, new EmbeddedCrowdUpgradeTask());
    }

    public static class ChainedUpgradeTask
    implements UpgradeTask {
        private final List<UpgradeTask> tasks;

        public ChainedUpgradeTask(List<UpgradeTask> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
            for (UpgradeTask task : this.tasks) {
                task.beforeUpgradeScript(conn, type);
            }
        }

        @Override
        public void upgradeFailed(Connection conn, DBType type) throws SQLException {
            for (UpgradeTask task : this.tasks) {
                task.upgradeFailed(conn, type);
            }
        }

        @Override
        public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
            for (UpgradeTask task : this.tasks) {
                task.afterUpgradeScript(conn, type);
            }
        }
    }
}

