/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import java.io.File;
import java.io.IOException;

public enum UpgradeConfig {
    INSTANCE;

    private DB0Handle db0Handle;

    public static File getData0File() {
        return new File(AppConfig.getVarDataDir(), "data0.bin");
    }

    private void closeDB0() {
        if (this.db0Handle != null) {
            this.db0Handle.write(new DB0Handle.Writer<Void>(){

                @Override
                public Void write(InfinityDbHandle db) {
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (IOException e2) {
                            Logs.APP_LOG.warn((Object)("problem closing db0 " + e2.getMessage()), (Throwable)e2);
                        }
                    }
                    return null;
                }
            });
        }
    }

    public boolean isDBopen() {
        return this.db0Handle != null && this.db0Handle.isOpen();
    }

    public Exception getDBOpenTrace() {
        return this.db0Handle == null ? null : this.db0Handle.getOpenTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDB() throws DbException, ConfigException {
        if (this.db0Handle == null) {
            UpgradeConfig upgradeConfig = this;
            synchronized (upgradeConfig) {
                if (this.db0Handle == null) {
                    try {
                        File db0File = UpgradeConfig.getData0File();
                        this.db0Handle = new DB0Handle(db0File);
                    }
                    catch (IOException e2) {
                        throw new DbException(e2);
                    }
                }
            }
        }
        this.openDB0();
    }

    public void openDB0() throws DbException {
        this.db0Handle.read(new DB0Handle.ReaderE<Void, DbException>(){

            @Override
            public Void read(InfinityDbHandle db) throws DbException {
                db.get();
                return null;
            }
        });
    }

    public DB0Handle getDB0Handle() {
        if (this.db0Handle == null) {
            try {
                this.startDB();
            }
            catch (ConfigException e2) {
                throw new DbException(e2);
            }
        }
        return this.db0Handle;
    }
}

