/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class StoredPathHashingTask
implements UpgradeTask {
    public static final int BATCH_SIZE = 10000;

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        Logs.APP_LOG.info((Object)"Upgrading data in cru_stored_path table");
        int batchCounter = 0;
        boolean oldAutoCommitValue = conn.getAutoCommit();
        conn.setAutoCommit(false);
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            conn.rollback();
            ps = conn.prepareStatement("UPDATE cru_stored_path SET cru_hash = ? WHERE cru_path_id = ?");
            resultSet = conn.createStatement().executeQuery("SELECT cru_path_id, cru_path FROM cru_stored_path WHERE cru_path IS NOT NULL");
            while (resultSet.next()) {
                int pathId = resultSet.getInt(1);
                String path = resultSet.getString(2);
                String hash = this.calculateHash(path);
                ps.setString(1, hash);
                ps.setInt(2, pathId);
                ps.addBatch();
                if (++batchCounter != 10000) continue;
                batchCounter = 0;
                this.flush(ps);
                Logs.APP_LOG.info((Object)"Upgraded 10000 rows");
            }
            if (batchCounter > 0) {
                this.flush(ps);
                Logs.APP_LOG.info((Object)("Upgraded " + batchCounter + " rows"));
            }
            this.crashIfHashCollisionFound(conn);
            StoredPathHashingTask.addHashColumnUniqueConstraintAndIndex(conn, type);
        }
        catch (Throwable throwable) {
            if (!conn.isClosed()) {
                JDBCHelper.closeQuietly(resultSet);
                JDBCHelper.closeQuietly(ps);
                conn.setAutoCommit(oldAutoCommitValue);
            }
            throw throwable;
        }
        if (!conn.isClosed()) {
            JDBCHelper.closeQuietly(resultSet);
            JDBCHelper.closeQuietly(ps);
            conn.setAutoCommit(oldAutoCommitValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHashColumnUniqueConstraintAndIndex(Connection conn, DBType type) throws SQLException {
        String addIndexQuery;
        Logs.APP_LOG.info((Object)"cru_stored_path upgrade: adding index");
        switch (type) {
            case MYSQL: {
                addIndexQuery = "ALTER TABLE cru_stored_path MODIFY COLUMN cru_hash varchar(128) unique";
                break;
            }
            default: {
                addIndexQuery = "ALTER TABLE cru_stored_path ADD CONSTRAINT cru_stored_path_cru_hash_key UNIQUE (cru_hash)";
            }
        }
        Statement s2 = conn.createStatement();
        try {
            s2.execute(addIndexQuery);
            Logs.APP_LOG.info((Object)"cru_stored_path upgrade: index added");
        }
        finally {
            JDBCHelper.closeQuietly(s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashIfHashCollisionFound(Connection conn) throws SQLException {
        ResultSet dupesResultSet = null;
        try {
            dupesResultSet = conn.createStatement().executeQuery("   SELECT cru_hash, MIN(cru_path), MAX(cru_path)     FROM cru_stored_path GROUP BY cru_hash    HAVING COUNT(cru_path_id) > 1");
            boolean exit = false;
            while (dupesResultSet.next()) {
                String hash = dupesResultSet.getString(1);
                String minPath = dupesResultSet.getString(2);
                String maxPath = dupesResultSet.getString(3);
                Logs.APP_LOG.fatal((Object)("Hash (SHA-256) conflict found: StoredPath(" + minPath + ") is found to have same hash [" + hash + "] as path [" + maxPath + "]"));
                exit = true;
            }
            if (exit) {
                throw new RuntimeException("System error occurred, unable to complete requested operation. Please consult system logs for more details.");
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(dupesResultSet);
            throw throwable;
        }
        JDBCHelper.closeQuietly(dupesResultSet);
    }

    private void flush(PreparedStatement ps) throws SQLException {
        for (int result : ps.executeBatch()) {
            if (result != -3) continue;
            throw new SQLException("SQL batch insert failed.");
        }
        ps.getConnection().commit();
    }

    String calculateHash(String path) {
        return HashUtils.getDefaultDigestHexEncoded(path);
    }
}

