/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.atlassian.fecru.properties.RepositoryProperty;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.StringClobType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.PropertiesType;
import com.cenqua.fisheye.config1.PropertyType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.cenqua.fisheye.util.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SalPropertiesUpgradeTask
implements UpgradeTask {
    private int index = 0;
    private Map<Pair<String, String>, String> repositoryKeyPairs = new HashMap<Pair<String, String>, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterUpgradeScript(Connection conn, DBType dbType) throws SQLException, CruDBException {
        RootConfig rootConfig = AppConfig.getsConfig();
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            if (rootConfig.getConfig().isSetProperties()) {
                this.upgradePropertiesType(conn, rootConfig.getConfig().getProperties(), "<ALL_REPOS>");
                rootConfig.getConfig().unsetProperties();
            }
            for (RepositoryType repositoryType : rootConfig.getConfig().getRepositoryArray()) {
                if (!repositoryType.isSetProperties()) continue;
                this.upgradePropertiesType(conn, repositoryType.getProperties(), repositoryType.getName());
                repositoryType.unsetProperties();
            }
            if (rootConfig.getConfig().getRepositoryDefaults().isSetProperties()) {
                Logs.APP_LOG.warn((Object)"Default Repostiory properties were found during the upgrade. These properties are not used anywhere, and will not be migrated to the database. The properties will remain in FISHEYE_INST/config.xml file under <repository-defaults><properties> for your reference, but will not be used.");
            }
            conn.commit();
        }
        finally {
            if (!conn.isClosed()) {
                conn.setAutoCommit(autoCommit);
            }
        }
        try {
            rootConfig.saveConfig();
        }
        catch (IOException e2) {
            throw new RuntimeException("Error saving config.xml after upgrade", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePropertiesType(Connection conn, PropertiesType propertiesType, String repository) throws SQLException {
        for (PropertyType propertyType : propertiesType.getPropertyArray()) {
            String propertyName = propertyType.getName();
            String value = propertyType.getValue();
            Pair<String, String> repositoryKeyPair = Pair.newInstance(repository, propertyName);
            if (this.repositoryKeyPairs.containsKey(repositoryKeyPair)) {
                Logs.APP_LOG.info((Object)("Duplicate property for repository '" + repository + "' property '" + propertyName + "' already set with value: '" + this.repositoryKeyPairs.get(repositoryKeyPair) + "'. Ignoring new value: '" + value + "'"));
                continue;
            }
            this.repositoryKeyPairs.put(repositoryKeyPair, value);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                Logs.APP_LOG.warn((Object)("Error upgrading property '" + propertyName + "'. Using encoded value '" + value + "'. " + e2.getMessage()));
            }
            PreparedStatement ps = conn.prepareStatement("insert into cru_repository_property (cru_repo_prop_id, cru_repository, cru_property_name, cru_repo_prop_hash, cru_value) values (?, ?, ?, ?, ?)");
            try {
                RepositoryProperty property = new RepositoryProperty(repository, propertyName, value);
                ps.setInt(1, this.index++);
                ps.setString(2, property.getRepository());
                ps.setString(3, property.getPropertyName());
                ps.setString(4, property.getHash());
                new StringClobType().nullSafeSet(ps, property.getValue(), 5);
                if (ps.executeUpdate() == 1) continue;
                throw new RuntimeException("Failed to upgrade repository '" + repository + "' property '" + propertyName + "' value '" + value + "' from config.xml to the database.");
            }
            finally {
                JDBCHelper.closeQuietly(ps);
            }
        }
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
        RootConfig rootConfig = AppConfig.getsConfig();
        rootConfig.reload();
        try {
            rootConfig.saveConfig();
        }
        catch (IOException e2) {
            throw new RuntimeException("Error restoring config.xml after upgrade failure.", e2);
        }
    }

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }
}

