/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.atlassian.fecru.util.Comparators;
import com.atlassian.fecru.util.StringFunctions;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProjectKeyUpperCaseUpgradeTask
implements UpgradeTask {
    static final String CRU_PROJECT = "cru_project";
    static final String CRU_REVPERMAID = "cru_revpermaid";
    static final String CRU_RECENTLY_VISITED = "cru_recently_visited";
    static final String UNIQUE_PROJECT_KEY_UPGRADE_SUFIX = "UPGRADE";

    @Override
    public void beforeUpgradeScript(Connection connection, DBType type) throws SQLException, CruDBException {
    }

    @Override
    public void upgradeFailed(Connection connection, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection connection, DBType type) throws SQLException, CruDBException {
        Preconditions.checkArgument((boolean)connection.getAutoCommit());
        Logs.APP_LOG.info((Object)"[projectKey.uppercase] Uppercase project keys start...");
        try {
            AtomicInteger uniqueIdGen = new AtomicInteger(0);
            Map<String, String> dictionaryCruProject = ProjectKeyUpperCaseUpgradeTask.upgradeCruProject(connection, uniqueIdGen);
            Map<String, String> dictionaryCruRevPermaid = ProjectKeyUpperCaseUpgradeTask.upgradeCruRevPermaId(connection, uniqueIdGen, dictionaryCruProject);
            int countDeletedFromRecentlyVisited = ProjectKeyUpperCaseUpgradeTask.deleteFromRecentlyVisitedProjectsReviewsAndSnippetsForProjectKeys(connection, (Set<String>)ImmutableSet.builder().addAll(dictionaryCruProject.keySet()).addAll(dictionaryCruRevPermaid.keySet()).build());
            ProjectKeyUpperCaseUpgradeTask.logSummaryFor(CRU_PROJECT, dictionaryCruProject);
            ProjectKeyUpperCaseUpgradeTask.logSummaryFor(CRU_REVPERMAID, dictionaryCruRevPermaid);
            Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] Number of deleted projects, reviews and snippets from %s : %d", CRU_RECENTLY_VISITED, countDeletedFromRecentlyVisited));
            Logs.APP_LOG.info((Object)"[projectKey.uppercase] ...uppercase project keys done.");
        }
        catch (SQLException sqlException) {
            Logs.APP_LOG.fatal((Object)String.format("[projectKey.uppercase] ...uppercase project keys failed with: %s. Application is in an unknown state. ", sqlException.getMessage()), (Throwable)sqlException);
            throw sqlException;
        }
    }

    private static void logSummaryFor(String tableName, Map<String, String> changesOldToNewProjectKeys) {
        Joiner.MapJoiner mapJoiner = Joiner.on((char)',').withKeyValueSeparator("=");
        if (!changesOldToNewProjectKeys.isEmpty()) {
            Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] Summary for project keys changed for %s: %s", tableName, mapJoiner.join(changesOldToNewProjectKeys)));
        } else {
            Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] Nothing changed in %s", tableName));
        }
    }

    private static Map<String, String> upgradeCruProject(Connection connection, AtomicInteger uniqueIdGen) throws SQLException {
        Set<String> currentProjectKeys = ProjectKeyUpperCaseUpgradeTask.listProjectKeysFrom(connection, CRU_PROJECT);
        Set currentNotUpperCaseProjectKeys = currentProjectKeys.stream().filter(projectKey -> !StringFunctions.isUpperCaseUS(projectKey)).collect(Collectors.toSet());
        Set currentUpperCaseProjectKeys = currentProjectKeys.stream().filter(projectKey -> StringFunctions.isUpperCaseUS(projectKey)).collect(Collectors.toSet());
        Map<String, String> dictionaryOfUpperCaseProjectKeys = currentUpperCaseProjectKeys.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        if (!currentNotUpperCaseProjectKeys.isEmpty()) {
            Map<String, String> oldToNewProjectKeys = ProjectKeyUpperCaseUpgradeTask.generateNewProjectKeys(currentProjectKeys, dictionaryOfUpperCaseProjectKeys, uniqueIdGen);
            ProjectKeyUpperCaseUpgradeTask.upperCaseProjectKeysOn(connection, oldToNewProjectKeys, CRU_PROJECT);
            return oldToNewProjectKeys;
        }
        return ImmutableMap.of();
    }

    private static Map<String, String> upgradeCruRevPermaId(Connection connection, AtomicInteger uniqueIdGen, Map<String, String> dictionaryOldToNewProjectKeys) throws SQLException {
        Set<String> permaidProjectKeys = ProjectKeyUpperCaseUpgradeTask.listProjectKeysFrom(connection, CRU_REVPERMAID);
        if (!permaidProjectKeys.isEmpty()) {
            Map<String, String> oldToNewProjectKeys = ProjectKeyUpperCaseUpgradeTask.generateNewProjectKeys(permaidProjectKeys, dictionaryOldToNewProjectKeys, uniqueIdGen);
            ProjectKeyUpperCaseUpgradeTask.upperCaseProjectKeysOn(connection, oldToNewProjectKeys, CRU_REVPERMAID);
            return oldToNewProjectKeys;
        }
        return ImmutableMap.of();
    }

    private static Map<String, String> generateNewProjectKeys(Set<String> allOldProjectKeys, Map<String, String> dictionaryOldToNewProjectKeys, AtomicInteger uniqueIdGen) {
        HashMap newToOldProjectKeys = Maps.newHashMap();
        Sets.SetView dictionaryProjectKeysUsed = Sets.intersection(allOldProjectKeys, dictionaryOldToNewProjectKeys.keySet());
        Map usableDictionaryOldToNewProjectKeys = Maps.filterKeys(dictionaryOldToNewProjectKeys, arg_0 -> ProjectKeyUpperCaseUpgradeTask.lambda$generateNewProjectKeys$117((Set)dictionaryProjectKeysUsed, arg_0));
        Map<String, String> usableDictionaryNewToOldProjectKeys = usableDictionaryOldToNewProjectKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        newToOldProjectKeys.putAll(usableDictionaryNewToOldProjectKeys);
        Sets.SetView unresolvedOldProjectKeys = Sets.difference(allOldProjectKeys, usableDictionaryOldToNewProjectKeys.keySet());
        Map optimisticOldToNewMapping = allOldProjectKeys.stream().collect(Collectors.toMap(Function.identity(), StringFunctions::toUpperCaseUS));
        for (String projectKey : unresolvedOldProjectKeys) {
            optimisticOldToNewMapping.remove(projectKey);
            String upperCaseProjectKey = StringFunctions.toUpperCaseUS(projectKey);
            if (newToOldProjectKeys.containsKey(upperCaseProjectKey)) {
                String upperCaseProjectKeyWithUniqueSuffix;
                while (newToOldProjectKeys.containsKey(upperCaseProjectKeyWithUniqueSuffix = upperCaseProjectKey + UNIQUE_PROJECT_KEY_UPGRADE_SUFIX + uniqueIdGen.incrementAndGet()) || optimisticOldToNewMapping.values().contains(upperCaseProjectKeyWithUniqueSuffix)) {
                }
                Logs.APP_LOG.warn((Object)String.format("[projectKey.uppercase] Project key: %s will be renamed to: %s", projectKey, upperCaseProjectKeyWithUniqueSuffix));
                newToOldProjectKeys.put(upperCaseProjectKeyWithUniqueSuffix, projectKey);
                continue;
            }
            newToOldProjectKeys.put(upperCaseProjectKey, projectKey);
        }
        return newToOldProjectKeys.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private static void upperCaseProjectKeysOn(Connection connection, Map<String, String> oldToNewProjectKeys, String updateTable) throws SQLException {
        Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] About to upper case %d project keys on %s", oldToNewProjectKeys.size(), updateTable));
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + updateTable + " SET cru_proj_key = ? WHERE cru_proj_key = ?");){
            Map oldToNewProjectKeysSortedByUpperCaseFirst = oldToNewProjectKeys.entrySet().stream().sorted(Comparator.comparing(e2 -> (String)e2.getKey(), Comparators.UPPERCASE_FIRST_COMPARATOR)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            for (Map.Entry oldToNewProjectKey : oldToNewProjectKeysSortedByUpperCaseFirst.entrySet()) {
                Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] About to uppercase project key from: %s to %s on %s", oldToNewProjectKey.getKey(), oldToNewProjectKey.getValue(), updateTable));
                preparedStatement.setString(1, (String)oldToNewProjectKey.getValue());
                preparedStatement.setString(2, (String)oldToNewProjectKey.getKey());
                preparedStatement.addBatch();
            }
            int[] updateBatchResult = preparedStatement.executeBatch();
            Logs.APP_LOG.info((Object)String.format("[projectKey.uppercase] Done uppercase update on %d project keys on %s", updateBatchResult.length, updateTable));
        }
    }

    private static Set<String> listProjectKeysFrom(Connection connection, String fromTable) throws SQLException {
        TreeSet projectKeys = Sets.newTreeSet();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT cru_proj_key FROM " + fromTable + " ORDER BY cru_proj_key");
            while (resultSet.next()) {
                String projectKey = resultSet.getString(1);
                projectKeys.add(projectKey);
            }
        }
        return projectKeys;
    }

    private static int deleteFromRecentlyVisitedProjectsReviewsAndSnippetsForProjectKeys(Connection connection, Set<String> projectKeys) throws SQLException {
        int count = 0;
        for (String projectKey : projectKeys) {
            count += ProjectKeyUpperCaseUpgradeTask.deleteFromRecentlyVisitedProjectsReviewsAndSnippetsForProjectKey(connection, projectKey);
        }
        return count;
    }

    private static int deleteFromRecentlyVisitedProjectsReviewsAndSnippetsForProjectKey(Connection connection, String projectKey) throws SQLException {
        int count = 0;
        count += ProjectKeyUpperCaseUpgradeTask.deleteFromRecentlyVisited(connection, RecentlyVisitedItem.Type.PROJECT, projectKey);
        count += ProjectKeyUpperCaseUpgradeTask.deleteFromRecentlyVisited(connection, RecentlyVisitedItem.Type.REVIEW, projectKey + "-%");
        return count += ProjectKeyUpperCaseUpgradeTask.deleteFromRecentlyVisited(connection, RecentlyVisitedItem.Type.SNIPPET, projectKey + "-%");
    }

    private static int deleteFromRecentlyVisited(Connection connection, RecentlyVisitedItem.Type type, String entityIdLike) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM cru_recently_visited WHERE cru_item_type = ? and cru_entity_id like ?");){
            preparedStatement.setString(1, type.getType());
            preparedStatement.setString(2, entityIdLike);
            int n2 = preparedStatement.executeUpdate();
            return n2;
        }
    }

    private static /* synthetic */ boolean lambda$generateNewProjectKeys$117(Set dictionaryProjectKeysUsed, String projectKey) {
        return dictionaryProjectKeysUsed.contains(projectKey);
    }
}

