/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.DB0HandleUtil;
import com.cenqua.crucible.hibernate.upgrade.DB0LoginCookie;
import com.cenqua.crucible.hibernate.upgrade.LoginEAV;
import com.cenqua.crucible.hibernate.upgrade.UpgradeDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeUserIdResolver;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class LoginCookieMigrationUpgradeTask
implements UpgradeTask {
    private static final String INSERT_LOGIN_COOKIE = "insert into cru_login_cookie (cru_login_cookie_id,cru_user_id,cru_rnd,cru_create_date,cru_type,cru_url,cru_recursive_url) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_LOGIN_COOKIE = "delete from cru_login_cookie";
    private final DB0HandleFactory db0HandleFactory;

    public LoginCookieMigrationUpgradeTask(DB0HandleFactory db0HandleFactory) {
        this.db0HandleFactory = db0HandleFactory;
    }

    public LoginCookieMigrationUpgradeTask() {
        this(new UpgradeDB0HandleFactory());
    }

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        Preconditions.checkArgument((boolean)conn.getAutoCommit());
        Logs.APP_LOG.info((Object)"[data0.bin] Migrating login cookies from data0.bin to SQL database.");
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        LoginCookieMigrationUpgradeTask.sqlDeleteLoginCookies(conn);
        DB0Handle db0Handle = null;
        try {
            db0Handle = this.db0HandleFactory.getInstance();
            UpgradeUserIdResolver userIdResolver = new UpgradeUserIdResolver(conn);
            List<DB0LoginCookie> loginCookiesWithDups = LoginCookieMigrationUpgradeTask.findLoginCookies(db0Handle);
            List<DB0LoginCookie> loginCookies = LoginCookieMigrationUpgradeTask.deduplicate(loginCookiesWithDups);
            int count = 0;
            for (DB0LoginCookie loginCookie : loginCookies) {
                Integer userId = userIdResolver.resolve(loginCookie.getUsername());
                if (userId == null) {
                    Logs.APP_LOG.debug((Object)String.format("[data0.bin] Ignoring login cookie for user %s. User is not present in the user table: %s", loginCookie.getUsername(), loginCookie));
                    continue;
                }
                try {
                    LoginCookieMigrationUpgradeTask.sqlInsertLoginCookie(conn, loginCookie, userId);
                    ++count;
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)String.format("[data0.bin] Error when inserting login cookie: %s, %s", loginCookie, e2.getMessage()));
                }
            }
            stopwatch.stop();
            Logs.APP_LOG.info((Object)String.format("[data0.bin] Migrated %d from %d login cookies in %s.", count, loginCookiesWithDups.size(), stopwatch.toString()));
        }
        catch (Exception e3) {
            throw new IllegalStateException("Error during login cookie migration", e3);
        }
        finally {
            DB0HandleUtil.close(db0Handle);
        }
    }

    private static List<DB0LoginCookie> deduplicate(List<DB0LoginCookie> loginCookiesWithDups) {
        HashMap loginCookiesByLoginId = Maps.newHashMap();
        for (DB0LoginCookie loginCookie : loginCookiesWithDups) {
            DB0LoginCookie previous = loginCookiesByLoginId.put(loginCookie.getLoginId(), loginCookie);
            if (previous == null) continue;
            Logs.APP_LOG.warn((Object)String.format("[data0.bin] A duplicated login cookie will be ignored: %s", previous));
        }
        return ImmutableList.copyOf(loginCookiesByLoginId.values());
    }

    private static List<DB0LoginCookie> findLoginCookies(DB0Handle db0Handle) {
        return db0Handle.read(new DB0Handle.Reader<List<DB0LoginCookie>>(){

            @Override
            public List<DB0LoginCookie> read(InfinityDbHandle db) throws DbException {
                LoginEAV loginEAV = new LoginEAV(db);
                return loginEAV.findLoginCookies();
            }
        });
    }

    private static void sqlDeleteLoginCookies(Connection conn) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(DELETE_LOGIN_COOKIE);
            statement.executeUpdate();
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not clean group tables", e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private static void sqlInsertLoginCookie(Connection conn, DB0LoginCookie loginCookie, Integer userId) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_LOGIN_COOKIE);
            statement.setLong(1, loginCookie.getLoginId());
            statement.setInt(2, userId);
            statement.setString(3, loginCookie.getRnd());
            statement.setLong(4, loginCookie.getCreateDate());
            statement.setInt(5, loginCookie.getType());
            statement.setString(6, loginCookie.getUrl());
            statement.setBoolean(7, loginCookie.getRecursiveUrl());
            if (statement.executeUpdate() == 0) {
                throw new IllegalStateException(String.format("LoginCookie could not be created: %s", loginCookie));
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Could not migrate login cookie: %s", loginCookie), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

