/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.LogTableUpgradePatterns;
import com.cenqua.crucible.hibernate.upgrade.UpgradeUtil;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogTableUpgrader56 {
    private Connection conn;
    private Map<String, Integer> userNames = new HashMap<String, Integer>();
    private Map<String, Integer> displayNames = new HashMap<String, Integer>();

    public LogTableUpgrader56(Connection conn) throws SQLException, IOException, DbException {
        this.conn = conn;
        UpgradeUtil.initUserMaps(conn, this.userNames, this.displayNames);
    }

    LogTableUpgrader56(Connection conn, Map<String, Integer> userNames, Map<String, Integer> displayNames) throws SQLException {
        this.conn = conn;
        this.userNames = userNames;
        this.displayNames = displayNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpgrade() throws SQLException, IOException {
        Logs.APP_LOG.info((Object)"Upgrading data in cru_logitem table");
        int count = 0;
        PreparedStatement psSelect = this.conn.prepareStatement("Select cru_logitem_id, cru_description, cru_action from cru_logitem order by cru_logitem_id");
        ResultSet logSet = null;
        try {
            logSet = psSelect.executeQuery();
            while (logSet.next()) {
                int id = logSet.getInt(1);
                this.saveLogItem(id, this.parseItem(logSet.getString(2), logSet.getString(3), id));
                if (++count % 10000 != 0) continue;
                Logs.APP_LOG.info((Object)("Upgraded " + count + " rows"));
            }
        }
        finally {
            JDBCHelper.closeQuietly(logSet, psSelect);
        }
    }

    protected ExtractedData parseItem(String description, String action, int id) {
        ExtractedData result = null;
        switch (LogAction.getAction(action)) {
            case REVIEW_CREATED: 
            case REVIEW_REWORK_CREATED: 
            case REVIEW_COMPLETED: 
            case REVIEW_JIRA_KEY_DELETED: {
                return null;
            }
            case REVIEW_TITLE_CHANGED: 
            case REVIEW_DESCRIPTION_CHANGED: 
            case REVIEW_REPOSITORY_CHANGED: 
            case REVIEW_DUE_DATE_CHANGED: 
            case REVIEW_ALLOW_JOIN_CHANGED: 
            case REVIEW_AUTHOR_CHANGED: 
            case REVIEW_JIRA_KEY_CHANGED: 
            case REVIEW_MODERATOR_CHANGED: 
            case REVIEW_PARENT_REVIEW_CHANGED: 
            case REVIEW_SUMMARY_CHANGED: {
                result = this.parseReviewChanged(description);
                break;
            }
            case REVIEW_STATE_CHANGE: {
                result = this.parseReviewStateChange(description);
                break;
            }
            case COMMENT_ADDED: {
                result = this.parseCommentAdded(description);
                break;
            }
            case COMMENT_DELETED: {
                result = this.parseCommentDeleted(description);
                break;
            }
            case COMMENT_UPDATED: {
                result = this.parseCommentUpdated(description);
                break;
            }
            case COMMENT_CHANGED: {
                result = this.parseCommentChanged(description);
                break;
            }
            case REVIEW_REVIEWER_REMOVED: 
            case REVIEW_REVIEWER_ADDED: {
                result = this.parseReviewerAddedOrRemoved(description);
                break;
            }
            case REVIEW_SEARCH_ADDED: {
                result = this.parseSearchAdded(description);
                break;
            }
            case COMMENT_REDRAFTED: 
            case REVIEW_FRX_REMOVED: 
            case JIRA_ISSUE_DELETED: 
            case SCRIPT_EXECUTED: 
            case JIRA_ISSUE_NOT_DELETED: 
            case REVIEW_REVIEWER_INVITE_ERROR: 
            case REVIEW_FRX_ADDED: 
            case UNKNOWN: 
            case REVIEW_REVIEWER_UNINVITED: 
            case REVIEW_REVISION_REMOVED: 
            case REVIEW_REVISION_ADDED: 
            case REVIEW_REVISION_UPDATED: {
                return null;
            }
        }
        if (result == null) {
            Logs.APP_LOG.info((Object)("Could not parse log item " + id + " \t" + action + " \t" + description));
        }
        return result;
    }

    private ExtractedData parseCommentUpdated(String description) {
        return this.parse(description, LogTableUpgradePatterns.COMMENT, 6, -1, -1);
    }

    private ExtractedData parseSearchAdded(String description) {
        return this.parse(description, LogTableUpgradePatterns.ALTERING_REVIEW, -1, -1, 6);
    }

    private ExtractedData parseReviewerAddedOrRemoved(String description) {
        Matcher m2 = LogTableUpgradePatterns.ALTERING_REVIEW.matcher(description);
        if (m2.matches()) {
            String name = m2.group(8);
            Integer user = this.userNames.get(name);
            if (user != null) {
                return new ExtractedData(user, null, null);
            }
            user = this.displayNames.get(name);
            if (user != null) {
                return new ExtractedData(user, null, null);
            }
        } else {
            Integer user = this.userNames.get(description);
            if (user != null) {
                return new ExtractedData(user, null, null);
            }
        }
        return null;
    }

    private ExtractedData parseReviewChanged(String description) {
        ExtractedData result = this.parse(description, LogTableUpgradePatterns.ALTERING_REVIEW, -1, -1, 13);
        if (result == null) {
            result = this.parse(description, LogTableUpgradePatterns.ALTERING_REVIEW_NEW, -1, 1, 2);
        }
        return result;
    }

    private ExtractedData parseCommentChanged(String description) {
        ExtractedData result = this.parse(description, LogTableUpgradePatterns.COMMENT_CHANGED, 5, 6, 7);
        if (result == null) {
            result = this.parse(description, LogTableUpgradePatterns.COMMENT_CHANGED_NEW, 1, 2, 3);
        }
        return result;
    }

    private ExtractedData parseCommentDeleted(String description) {
        ExtractedData result = this.parse(description, LogTableUpgradePatterns.COMMENT, 7, 9, -1);
        if (result == null) {
            result = this.parse(description, LogTableUpgradePatterns.DELETE_COMMENT, 1, 2, -1);
        }
        if (result == null) {
            result = this.parse(description, LogTableUpgradePatterns.COMMENT_DELETED_NEW, 1, 2, -1);
        }
        return result;
    }

    private ExtractedData parse(String description, Pattern pattern, int entityGroup, int oldValueGroup, int newValueGroup) {
        Matcher m2 = pattern.matcher(description);
        if (m2.matches()) {
            Integer entityId = entityGroup > 0 ? Integer.valueOf(Integer.parseInt(m2.group(entityGroup))) : null;
            String oldValue = oldValueGroup > 0 ? m2.group(oldValueGroup) : null;
            String newValue = newValueGroup > 0 ? m2.group(newValueGroup) : null;
            return new ExtractedData(entityId, oldValue, newValue);
        }
        return null;
    }

    private ExtractedData parseCommentAdded(String description) {
        ExtractedData result = this.parse(description, LogTableUpgradePatterns.COMMENT, 6, -1, -1);
        if (result == null) {
            result = this.parse(description, LogTableUpgradePatterns.COMMENT_ADDED_NEW, 1, -1, 2);
        }
        return result;
    }

    private ExtractedData parseReviewStateChange(String description) {
        Matcher m2 = LogTableUpgradePatterns.STATE_CHANGE.matcher(description);
        if (m2.matches()) {
            return new ExtractedData(null, null, m2.group(6));
        }
        m2 = LogTableUpgradePatterns.NEW_STATE_CHANGE.matcher(description);
        if (m2.matches()) {
            return new ExtractedData(null, m2.group(2), m2.group(3));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogItem(int id, ExtractedData result) throws SQLException {
        if (result != null) {
            try (PreparedStatement ps = this.conn.prepareStatement("Update cru_logitem set cru_entity_id=?, cru_old_value=?, cru_new_value=? where cru_logitem_id=?");){
                ps.setObject(1, result.entityId);
                ps.setObject(2, result.oldValue);
                ps.setString(3, result.newValue);
                ps.setInt(4, id);
                ps.executeUpdate();
            }
        }
    }

    public static class ExtractedData {
        private final Integer entityId;
        private final String oldValue;
        private final String newValue;

        public ExtractedData(Integer entityId, String oldValue, String newValue) {
            this.entityId = entityId;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Integer getEntityId() {
            return this.entityId;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }
    }
}

