/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.LogTableUpgradePatterns;
import com.cenqua.crucible.hibernate.upgrade.UpgradeUtil;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogTableUpgrader51 {
    private List<MessageParser> parsers = new ArrayList<MessageParser>();
    private Map<String, Integer> userNames = new HashMap<String, Integer>();
    private Map<String, Integer> displayNames = new HashMap<String, Integer>();
    private Map<String, Integer> reviewKeys = new HashMap<String, Integer>();
    private Set<String> unknownDisplayNames = new TreeSet<String>();
    private Set<String> unknownUserNames = new TreeSet<String>();
    private Set<String> unknownPermaIds = new TreeSet<String>();
    private Connection conn;

    public LogTableUpgrader51(Connection conn) throws SQLException, DbException, IOException {
        this.conn = conn;
        UpgradeUtil.initUserMaps(conn, this.userNames, this.displayNames);
        this.initReviewKeyMap();
        this.initParsers();
    }

    LogTableUpgrader51(Map<String, Integer> userNames, Map<String, Integer> displayNames, Map<String, Integer> reviewKeys) throws SQLException, DbException {
        this.initParsers();
        this.userNames = userNames;
        this.displayNames = displayNames;
        this.reviewKeys = reviewKeys;
    }

    private void initParsers() {
        this.parsers.add(new ReviewCreatedParser());
        this.parsers.add(new ReviewCompletedParser());
        this.parsers.add(new StateChangeParser());
        this.parsers.add(new CommentParser());
        this.parsers.add(new AlteringReviewParser());
        this.parsers.add(new UpdatedRevisionParser());
        this.parsers.add(new AddRemoveRevisionParser());
        this.parsers.add(new UpdatedRevision2Parser());
        this.parsers.add(new DeleteParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpgrade() throws SQLException, IOException {
        Logs.APP_LOG.info((Object)"Upgrading data in cru_logitem table");
        int count = 0;
        PreparedStatement psSelect = this.conn.prepareStatement("Select cru_logitem_id, cru_description from cru_logitem order by cru_logitem_id");
        ResultSet logSet = null;
        try {
            logSet = psSelect.executeQuery();
            while (logSet.next()) {
                int id = logSet.getInt(1);
                this.saveLogItem(id, this.parseItem(logSet.getString(2), id));
                if (++count % 10000 != 0) continue;
                Logs.APP_LOG.info((Object)("Upgraded " + count + " rows"));
            }
        }
        finally {
            JDBCHelper.closeQuietly(logSet, psSelect);
        }
        Logs.APP_LOG.info((Object)("Unknown issues: " + this.unknownPermaIds));
        Logs.APP_LOG.info((Object)("Unknown display names: " + this.unknownDisplayNames));
        Logs.APP_LOG.info((Object)("Unknown user names: " + this.unknownUserNames));
    }

    ParseResult parseItem(String item, int id) throws SQLException {
        if (item != null) {
            for (MessageParser p2 : this.parsers) {
                ParseResult result = p2.parseItem(item);
                if (result == null) continue;
                return result;
            }
        }
        Logs.APP_LOG.info((Object)("Unable to parse line " + id + ": " + item));
        return new ParseResult(LogAction.UNKNOWN, null, null);
    }

    private void initReviewKeyMap() throws SQLException {
        PreparedStatement psSelect = this.conn.prepareStatement("Select cru_review_id, cru_proj_key, cru_number from cru_revpermaid");
        ResultSet result = null;
        try {
            result = psSelect.executeQuery();
            while (result.next()) {
                this.reviewKeys.put(result.getString(2) + "-" + result.getInt(3), result.getInt(1));
            }
        }
        finally {
            JDBCHelper.closeQuietly(result, psSelect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogItem(int id, ParseResult parseResult) throws SQLException {
        try (PreparedStatement ps = this.conn.prepareStatement("Update cru_logitem set cru_review_id=?, cru_user_id=?, cru_action=? where cru_logitem_id=?");){
            ps.setObject(1, parseResult.reviewId);
            ps.setObject(2, parseResult.userId);
            ps.setString(3, parseResult.logAction.getKey());
            ps.setInt(4, id);
            ps.executeUpdate();
        }
    }

    private Integer getReviewIdFromPermaId(String key) throws SQLException {
        Integer reviewId = this.reviewKeys.get(key);
        if (reviewId == null) {
            this.unknownPermaIds.add(key);
        }
        return reviewId;
    }

    private Integer getUserIdFromUsername(String username) {
        Integer id = this.userNames.get(username);
        if (id == null) {
            this.unknownUserNames.add(username);
        }
        return id;
    }

    private Integer getUserIdFromDisplayName(String name) {
        Integer id = this.displayNames.get(name);
        if (id == null) {
            this.unknownDisplayNames.add(name);
        }
        return id;
    }

    public Set<String> getUnknownDisplayNames() {
        return this.unknownDisplayNames;
    }

    public Set<String> getUnknownUserNames() {
        return this.unknownUserNames;
    }

    public Set<String> getUnknownReviewKeys() {
        return this.unknownPermaIds;
    }

    static class ParseResult {
        final LogAction logAction;
        final Integer reviewId;
        final Integer userId;

        public ParseResult(LogAction logAction, Integer reviewId, Integer userId) {
            this.logAction = logAction;
            this.reviewId = reviewId;
            this.userId = userId;
        }
    }

    private class DeleteParser
    extends MessageParser {
        private DeleteParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.DELETE;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            LogAction result = m2.group(0).startsWith("Deleted linked Jira issue") ? LogAction.JIRA_ISSUE_DELETED : (m2.group(0).startsWith("Deleted comment") ? LogAction.COMMENT_DELETED : LogAction.UNKNOWN);
            return new ParseResult(result, null, null);
        }
    }

    private class UpdatedRevision2Parser
    extends MessageParser {
        private UpdatedRevision2Parser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.UPDATED_REVISION_2;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            return new ParseResult(LogAction.REVIEW_REVISION_UPDATED, null, LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(1)));
        }
    }

    private class AddRemoveRevisionParser
    extends MessageParser {
        private AddRemoveRevisionParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.ADD_REMOVE_REVISIONS;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            String verb = m2.group(2);
            LogAction result = verb.startsWith("adding") ? LogAction.REVIEW_REVISION_ADDED : (m2.group(3).startsWith("revision") ? LogAction.REVIEW_REVISION_REMOVED : LogAction.REVIEW_FRX_REMOVED);
            return new ParseResult(result, LogTableUpgrader51.this.getReviewIdFromPermaId(m2.group(5)), LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(1)));
        }
    }

    private class UpdatedRevisionParser
    extends MessageParser {
        private UpdatedRevisionParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.UPDATED_REVISION;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            return new ParseResult(LogAction.REVIEW_REVISION_UPDATED, null, LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(1)));
        }
    }

    private class AlteringReviewParser
    extends MessageParser {
        private AlteringReviewParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.ALTERING_REVIEW;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            LogAction result = LogAction.UNKNOWN;
            String actionString = m2.group(5);
            String verb = m2.group(10);
            String field = m2.group(11);
            if ("changing".equals(verb)) {
                if (LogTableUpgradePatterns.CHANGED_FIELD.containsKey(field)) {
                    result = LogTableUpgradePatterns.CHANGED_FIELD.get(field);
                }
            } else {
                result = "unlinked jira issue key".equals(actionString) ? LogAction.REVIEW_JIRA_KEY_DELETED : (actionString.startsWith("removing reviewer") ? LogAction.REVIEW_REVIEWER_REMOVED : (actionString.startsWith("adding reviewer") ? LogAction.REVIEW_REVIEWER_ADDED : (actionString.startsWith("error inviting user") ? LogAction.REVIEW_REVIEWER_ADDED : (actionString.startsWith("adding search") ? LogAction.REVIEW_SEARCH_ADDED : LogAction.UNKNOWN))));
            }
            return new ParseResult(result, LogTableUpgrader51.this.getReviewIdFromPermaId(m2.group(2)), LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(1)));
        }
    }

    private class CommentParser
    extends MessageParser {
        private CommentParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.COMMENT;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            String verb = m2.group(5);
            String text = m2.group(6);
            LogAction result = "posted".equals(verb) || "added".equals(verb) ? LogAction.COMMENT_ADDED : ("deleted".equals(verb) ? LogAction.COMMENT_DELETED : ("updated".equals(verb) ? LogAction.COMMENT_UPDATED : ("changed".equals(verb) ? ("back to draft.".equals(text) ? LogAction.COMMENT_REDRAFTED : LogAction.COMMENT_CHANGED) : LogAction.UNKNOWN)));
            return new ParseResult(result, LogTableUpgrader51.this.getReviewIdFromPermaId(m2.group(1)), LogTableUpgrader51.this.getUserIdFromUsername(m2.group(4)));
        }
    }

    private class StateChangeParser
    extends MessageParser {
        private StateChangeParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.STATE_CHANGE;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            return new ParseResult(LogAction.REVIEW_STATE_CHANGE, LogTableUpgrader51.this.getReviewIdFromPermaId(m2.group(1)), LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(4)));
        }
    }

    private class ReviewCompletedParser
    extends MessageParser {
        private ReviewCompletedParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.REVIEW_COMPLETED;
        }

        @Override
        ParseResult getParseResult(Matcher m2) throws SQLException {
            return new ParseResult(LogAction.REVIEW_COMPLETED, LogTableUpgrader51.this.getReviewIdFromPermaId(m2.group(1)), LogTableUpgrader51.this.getUserIdFromDisplayName(m2.group(4)));
        }
    }

    private class ReviewCreatedParser
    extends MessageParser {
        private ReviewCreatedParser() {
        }

        @Override
        public Pattern getPattern() {
            return LogTableUpgradePatterns.REVIEW_CREATED;
        }

        @Override
        ParseResult getParseResult(Matcher m2) {
            String text = m2.group(2);
            LogAction result = text.endsWith(": Rework") ? LogAction.REVIEW_REWORK_CREATED : LogAction.REVIEW_CREATED;
            return new ParseResult(result, Integer.parseInt(m2.group(1)), null);
        }
    }

    private abstract class MessageParser {
        Pattern pattern = this.getPattern();

        abstract Pattern getPattern();

        abstract ParseResult getParseResult(Matcher var1) throws SQLException;

        public ParseResult parseItem(String item) throws SQLException {
            Matcher m2 = this.pattern.matcher(item);
            if (m2.matches()) {
                return this.getParseResult(m2);
            }
            return null;
        }
    }
}

