/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.model.managers.LogAction;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class LogTableUpgradePatterns {
    public static final Map<String, LogAction> CHANGED_FIELD = new HashMap<String, LogAction>();
    private static final Pattern CHANGED_FIELD_EXP;
    public static final Pattern REVIEW_PERMA_ID;
    public static final Pattern ACTOR_DISPLAY_NAME;
    public static final Pattern ACTOR_USER_NAME;
    public static final Pattern MULTILINE_TEXT;
    public static final Pattern REVIEW_CREATED;
    public static final Pattern REVIEW_COMPLETED;
    public static final Pattern STATE_CHANGE;
    public static final Pattern COMMENT;
    public static final Pattern ALTERING_REVIEW;
    public static final Pattern UPDATED_REVISION;
    public static final Pattern ADD_REMOVE_REVISIONS;
    public static final Pattern DELETE;
    public static final Pattern UPDATED_REVISION_2;
    public static final Pattern NEW_STATE_CHANGE;
    public static final Pattern COMMENT_CHANGED;
    public static final Pattern DELETE_COMMENT;
    public static final Pattern COMMENT_CHANGED_NEW;
    public static final Pattern COMMENT_ADDED_NEW;
    public static final Pattern ALTERING_REVIEW_NEW;
    public static final Pattern COMMENT_DELETED_NEW;

    static {
        CHANGED_FIELD.put("title", LogAction.REVIEW_TITLE_CHANGED);
        CHANGED_FIELD.put("description", LogAction.REVIEW_DESCRIPTION_CHANGED);
        CHANGED_FIELD.put("allow reviewers to join", LogAction.REVIEW_ALLOW_JOIN_CHANGED);
        CHANGED_FIELD.put("due date", LogAction.REVIEW_DUE_DATE_CHANGED);
        CHANGED_FIELD.put("jira issue key", LogAction.REVIEW_JIRA_KEY_CHANGED);
        CHANGED_FIELD.put("author", LogAction.REVIEW_AUTHOR_CHANGED);
        CHANGED_FIELD.put("moderator", LogAction.REVIEW_MODERATOR_CHANGED);
        CHANGED_FIELD.put("repository", LogAction.REVIEW_REPOSITORY_CHANGED);
        CHANGED_FIELD.put("summary", LogAction.REVIEW_SUMMARY_CHANGED);
        CHANGED_FIELD.put("parent review", LogAction.REVIEW_PARENT_REVIEW_CHANGED);
        CHANGED_FIELD_EXP = Pattern.compile("(" + Joiner.on((String)"|").join(CHANGED_FIELD.keySet()) + ")");
        REVIEW_PERMA_ID = Pattern.compile("(([A-Z0-9\\-]+)-(\\d{1,9}))");
        ACTOR_DISPLAY_NAME = Pattern.compile("(.+)");
        ACTOR_USER_NAME = Pattern.compile("(.+)");
        MULTILINE_TEXT = Pattern.compile("(?s:.*?)");
        REVIEW_CREATED = Pattern.compile("Review: (\\d+) (" + MULTILINE_TEXT + "|" + REVIEW_PERMA_ID + ": Rework) created.");
        REVIEW_COMPLETED = Pattern.compile(REVIEW_PERMA_ID + ": " + ACTOR_DISPLAY_NAME + " completed review.");
        STATE_CHANGE = Pattern.compile(REVIEW_PERMA_ID + ": " + MULTILINE_TEXT + ", user " + ACTOR_DISPLAY_NAME + ", did (.+). Changed to state: (.+)");
        COMMENT = Pattern.compile(REVIEW_PERMA_ID + ": " + ACTOR_USER_NAME + " (posted|deleted|updated|added|changed) comment ((\\d+)(|: (\"" + MULTILINE_TEXT + "\" to \"" + MULTILINE_TEXT + "\"|" + MULTILINE_TEXT + "))|back to draft.)");
        ALTERING_REVIEW = Pattern.compile(ACTOR_DISPLAY_NAME + " altering " + REVIEW_PERMA_ID + " (unlinked jira issue key|adding search (" + MULTILINE_TEXT + ")|(adding|removing) reviewer (" + ACTOR_USER_NAME + ")|(changing) " + CHANGED_FIELD_EXP + " to (\"?)(" + MULTILINE_TEXT + ")(\"?))");
        UPDATED_REVISION = Pattern.compile(ACTOR_DISPLAY_NAME + " Updated .*, (was .*, now .*|now contains .*)");
        ADD_REMOVE_REVISIONS = Pattern.compile(ACTOR_DISPLAY_NAME + " (adding revision .*|removing (revision " + MULTILINE_TEXT + "|frx .*|revision .*)) (to|from) " + REVIEW_PERMA_ID + "(| replacing .*)");
        DELETE = Pattern.compile("(Deleted linked Jira issue .*|Deleted comment " + MULTILINE_TEXT + ")");
        UPDATED_REVISION_2 = Pattern.compile(ACTOR_DISPLAY_NAME + " updated revision .*");
        NEW_STATE_CHANGE = Pattern.compile("action:(.+) --- changed state (.+) to (.+)");
        COMMENT_CHANGED = Pattern.compile(REVIEW_PERMA_ID + ": " + ACTOR_USER_NAME + " changed comment (\\d+): \"(" + MULTILINE_TEXT + ")\" to \"(" + MULTILINE_TEXT + ")\"");
        DELETE_COMMENT = Pattern.compile("Deleted comment CMT:(\\d+): \"(" + MULTILINE_TEXT + ")\"");
        COMMENT_CHANGED_NEW = Pattern.compile("(\\d+): \"(" + MULTILINE_TEXT + ")\" -> \"(" + MULTILINE_TEXT + ")\"");
        COMMENT_ADDED_NEW = Pattern.compile("(\\d+): (" + MULTILINE_TEXT + ")");
        ALTERING_REVIEW_NEW = Pattern.compile("\"(" + MULTILINE_TEXT + "|null)\" -> \"(" + MULTILINE_TEXT + "|null)\"");
        COMMENT_DELETED_NEW = Pattern.compile("(\\d+): \"(" + MULTILINE_TEXT + ")\"");
    }
}

