/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class Hibernate4UpgradeTask
implements UpgradeTask {
    private static final Logger log = Logs.loggerFor(Hibernate4UpgradeTask.class);
    private static final Set<String> TABLES_WITH_UNIQUE_CONSTRAINTS = ImmutableSet.of((Object)"cru_commit_notification", (Object)"cru_builtin_group", (Object)"cru_comment_read_status", (Object)"cru_user", (Object)"cru_repository_property", (Object)"cru_stored_path", (Object[])new String[]{"cru_review_participant", "cru_perm_scheme", "cru_revision", "cru_watch", "cru_file_read_status", "cru_review_property"});

    /*
     * Unable to fully structure code
     */
    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        Hibernate4UpgradeTask.log.info((Object)"Starting Hibernate4UpgradeTask.beforeUpgradeScript");
        Hibernate4UpgradeTask.log.info((Object)"Dropping implicit unique constraints");
        statement = conn.createStatement();
        var6_4 = null;
        try {
            switch (1.$SwitchMap$com$cenqua$crucible$hibernate$DBType[type.ordinal()]) {
                case 1: {
                    constraintsToDrop = this.findConstraintsToDrop(conn, "SELECT CONSTRAINT_NAME, TABLE_NAME\nFROM INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS\nWHERE TABLE_NAME LIKE 'CRU_%'\nAND CONSTRAINT_TYPE='UNIQUE'", new Object[0]);
                    dropQuery = "DROP CONSTRAINT";
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 2: {
                    constraintsToDrop = this.findConstraintsToDrop(conn, "SELECT CONSTRAINT_NAME, TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS\nWHERE TABLE_NAME LIKE 'cru_%'\nAND CONSTRAINT_TYPE='UNIQUE'\nAND CONSTRAINT_SCHEMA=?", new Object[]{conn.getCatalog()});
                    dropQuery = "DROP INDEX";
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    constraintsToDrop = this.findConstraintsToDrop(conn, "SELECT pg_constraint.conname, pg_class.relname \nFROM pg_constraint INNER JOIN pg_class ON (pg_constraint.conrelid = pg_class.oid) \nWHERE pg_constraint.contype = 'u' AND pg_class.relname LIKE 'cru_%'", new Object[0]);
                    dropQuery = "DROP CONSTRAINT";
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 4: {
                    constraintsToDrop = this.findConstraintsToDrop(conn, "SELECT constraint_name, table_name\nFROM user_constraints\nWHERE table_name LIKE 'CRU_%' and constraint_type = 'U'", new Object[0]);
                    dropQuery = "DROP CONSTRAINT";
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    constraintsToDrop = this.findConstraintsToDrop(conn, "SELECT sys.key_constraints.name, sys.tables.name\nFROM sys.key_constraints INNER JOIN sys.tables ON (sys.key_constraints.parent_object_id = sys.tables.object_id)\nWHERE sys.key_constraints.type = 'UQ' AND sys.tables.name LIKE 'cru_%'", new Object[0]);
                    dropQuery = "DROP CONSTRAINT";
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported DB type for this upgrade " + (Object)type);
                }
            }
        }
        catch (Throwable var7_8) {
            var6_4 = var7_8;
            throw var7_8;
        }
        finally {
            if (statement != null) {
                if (var6_4 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable var7_7) {
                        var6_4.addSuppressed(var7_7);
                    }
                } else {
                    statement.close();
                }
            }
        }
        this.dropConstraints(conn, constraintsToDrop, dropQuery);
        Hibernate4UpgradeTask.log.info((Object)"Done Hibernate4UpgradeTask.beforeUpgradeScript");
    }

    private Iterable<Constraint> findConstraintsToDrop(Connection conn, String constraintsQuery, Object ... queryParams) throws SQLException {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        try (PreparedStatement st = conn.prepareStatement(constraintsQuery);){
            for (int i2 = 0; i2 < queryParams.length; ++i2) {
                st.setObject(i2 + 1, queryParams[i2]);
            }
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                String contraintName = rs.getString(1);
                String tableName = rs.getString(2);
                listBuilder.add((Object)new Constraint(contraintName, tableName));
            }
        }
        return listBuilder.build();
    }

    private void dropConstraints(Connection conn, Iterable<Constraint> constraintsToDrop, String dropConstraintSyntax) throws SQLException {
        try (Statement statement = conn.createStatement();){
            for (Constraint constraintToDrop : constraintsToDrop) {
                String constraintName = constraintToDrop.getConstraintName();
                String tableName = constraintToDrop.getTableName();
                if (TABLES_WITH_UNIQUE_CONSTRAINTS.contains(tableName.toLowerCase(Locale.US))) {
                    log.info((Object)("Dropping " + constraintName + " for " + tableName));
                    statement.executeUpdate("ALTER TABLE " + tableName + " " + dropConstraintSyntax + " " + constraintName);
                    continue;
                }
                log.info((Object)("Skipping " + tableName));
            }
        }
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }

    private static class Constraint {
        private final String constraintName;
        private final String tableName;

        Constraint(String constraintName, String tableName) {
            this.constraintName = constraintName;
            this.tableName = tableName;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

