/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.DB0HandleUtil;
import com.cenqua.crucible.hibernate.upgrade.UpgradeDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeUserIdResolver;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public class GroupMigrationUpgradeTask
implements UpgradeTask {
    private static final String INSERT_BUILTIN_GROUP = "insert into cru_builtin_group (cru_builtin_group_id, cru_builtin_group_name) values (?, ?)";
    private static final String INSERT_BUILTIN_GROUP_USER = "insert into cru_builtin_group_user (cru_builtin_group_id, cru_user_id) VALUES (?, ?)";
    private static final String DELETE_BUILTIN_GROUP = "delete from cru_builtin_group";
    private static final String DELETE_BUILTIN_GROUP_USER = "delete from cru_builtin_group_user";
    private final DB0HandleFactory db0HandleFactory;

    public GroupMigrationUpgradeTask(DB0HandleFactory db0HandleFactory) {
        this.db0HandleFactory = db0HandleFactory;
    }

    public GroupMigrationUpgradeTask() {
        this(new UpgradeDB0HandleFactory());
    }

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        Preconditions.checkArgument((boolean)conn.getAutoCommit());
        Logs.APP_LOG.info((Object)"[data0.bin] Migrating groups from data0.bin to SQL database.");
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        GroupMigrationUpgradeTask.sqlDeleteGroups(conn);
        DB0Handle db0Handle = null;
        try {
            db0Handle = this.db0HandleFactory.getInstance();
            List<String> groupNamesWithDups = DB0HandleUtil.getGroupNames(db0Handle);
            ImmutableList groupNames = ImmutableList.copyOf((Collection)Sets.newHashSet(groupNamesWithDups));
            UpgradeUserIdResolver userIdResolver = new UpgradeUserIdResolver(conn);
            int countGroups = 0;
            for (int i2 = 0; i2 < groupNames.size(); ++i2) {
                String groupName = (String)groupNames.get(i2);
                int builtinGroupId = i2;
                try {
                    GroupMigrationUpgradeTask.sqlInsertGroup(conn, builtinGroupId, groupName);
                    ++countGroups;
                    List<String> usernamesInGroup = DB0HandleUtil.getUsernamesInGroup(db0Handle, groupName);
                    int countGroupUserMapping = 0;
                    for (String username : usernamesInGroup) {
                        Integer userId = userIdResolver.resolve(username);
                        if (userId == null) {
                            Logs.APP_LOG.warn((Object)String.format("[data0.bin] Could not add user %s to group %s as user doesn't exist in user table.", username, groupName));
                            continue;
                        }
                        try {
                            GroupMigrationUpgradeTask.sqlInsertGroupUserMapping(conn, builtinGroupId, userId);
                            ++countGroupUserMapping;
                        }
                        catch (Exception e2) {
                            Logs.APP_LOG.warn((Object)String.format("[data0.bin] Error when inserting group-user mapping [%s, %s]: %s", groupName, username, e2.getMessage()));
                        }
                    }
                    Logs.APP_LOG.info((Object)String.format("[data0.bin] Migrated %d from %d group-user mapping in group %s.", countGroupUserMapping, usernamesInGroup.size(), groupName));
                    continue;
                }
                catch (Exception e3) {
                    Logs.APP_LOG.error((Object)String.format("[data0.bin] Error when inserting group [%s]: %s", groupName, e3.getMessage()));
                }
            }
            stopwatch.stop();
            Logs.APP_LOG.info((Object)String.format("[data0.bin] Migrated %d from %d groups in %s", countGroups, groupNamesWithDups.size(), stopwatch.toString()));
        }
        catch (Exception e4) {
            throw new IllegalStateException("Error during the group migration", e4);
        }
        finally {
            DB0HandleUtil.close(db0Handle);
        }
    }

    private static void sqlDeleteGroups(Connection conn) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.executeUpdate(DELETE_BUILTIN_GROUP_USER);
            statement.executeUpdate(DELETE_BUILTIN_GROUP);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not clean group tables", e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private static void sqlInsertGroup(Connection conn, int builtinGroupId, String builtinGroupName) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_BUILTIN_GROUP);
            statement.setInt(1, builtinGroupId);
            statement.setString(2, builtinGroupName);
            if (statement.executeUpdate() == 0) {
                throw new IllegalStateException(String.format("Group %s could not be created", builtinGroupName));
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Could not migrate group: %s", builtinGroupName), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private static void sqlInsertGroupUserMapping(Connection conn, int builtinGroupId, int userId) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_BUILTIN_GROUP_USER);
            statement.setInt(1, builtinGroupId);
            statement.setInt(2, userId);
            if (statement.executeUpdate() == 0) {
                throw new IllegalStateException(String.format("Group-User (%d, %d) could not be created", builtinGroupId, userId));
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Could not migrate group-user mapping: (%d, %d)", builtinGroupId, userId), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

