/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.cenqua.fisheye.util.Pair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DedupeStoredPathUpgradeTask
implements UpgradeTask {
    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStoredPathMap(Connection conn, String query, Map<Integer, Integer> storedPathMap) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(query);
        ResultSet duplicateStoredPaths = null;
        try {
            duplicateStoredPaths = ps.executeQuery();
            while (duplicateStoredPaths.next()) {
                int toId;
                int fromId = duplicateStoredPaths.getInt(1);
                if (fromId == (toId = duplicateStoredPaths.getInt(2))) continue;
                storedPathMap.put(fromId, toId);
            }
        }
        finally {
            JDBCHelper.closeQuietly(duplicateStoredPaths, ps);
        }
    }

    private Map<Integer, Integer> getStoredPathMap(Connection conn) throws SQLException {
        HashMap<Integer, Integer> storedPathMap = new HashMap<Integer, Integer>();
        Logs.APP_LOG.info((Object)"Selecting stored path duplicates which are not null");
        this.addToStoredPathMap(conn, "select c.from_id, c.to_id from    (select a.cru_path_id as from_id, min(b.cru_path_id) as to_id       from cru_stored_path a, cru_stored_path b      where a.cru_path = b.cru_path      group by a.cru_path_id) c  where c.from_id != c.to_id", storedPathMap);
        Logs.APP_LOG.info((Object)"Selecting stored path duplicates which are null");
        this.addToStoredPathMap(conn, "select c.from_id, c.to_id from    (select a.cru_path_id as from_id, min(b.cru_path_id) as to_id       from cru_stored_path a, cru_stored_path b      where a.cru_path is null and b.cru_path is null      group by a.cru_path_id) c  where c.from_id != c.to_id", storedPathMap);
        return storedPathMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, CrucibleRevisionTuple> getInvalidCruRevs(Connection conn, Map<Integer, Integer> storedPathMap) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("select cru_revision_id, cru_path, cru_source_name, cru_revision from cru_revision");
        ResultSet cruRevs = null;
        HashMap<Integer, CrucibleRevisionTuple> invalidCruRevs = new HashMap<Integer, CrucibleRevisionTuple>();
        try {
            cruRevs = ps.executeQuery();
            while (cruRevs.next()) {
                int revId = cruRevs.getInt(1);
                int pathId = cruRevs.getInt(2);
                String sourceName = cruRevs.getString(3);
                String revision = cruRevs.getString(4);
                if (!storedPathMap.containsKey(pathId)) continue;
                invalidCruRevs.put(revId, new CrucibleRevisionTuple(revId, sourceName, revision, pathId));
            }
        }
        finally {
            JDBCHelper.closeQuietly(cruRevs, ps);
        }
        return invalidCruRevs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Map<Integer, Integer>, Map<Integer, Integer>> processInvalidCruRevs(Connection conn, Map<Integer, Integer> storedPathMap, Map<Integer, CrucibleRevisionTuple> invalidCruRevs) throws SQLException {
        HashMap<Integer, Integer> invalidCruRevMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> revsToUpdate = new HashMap<Integer, Integer>();
        HashMap<CrucibleRevisionTuple, Integer> updatedRevs = new HashMap<CrucibleRevisionTuple, Integer>();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select cru_revision_id from cru_revision where cru_source_name = ? and cru_revision = ? and cru_path = ?");
            for (Map.Entry<Integer, CrucibleRevisionTuple> invalidRevEntry : invalidCruRevs.entrySet()) {
                ResultSet cruRevs;
                block10: {
                    Integer invalidRevId = invalidRevEntry.getKey();
                    CrucibleRevisionTuple invalidRev = invalidRevEntry.getValue();
                    Integer validPath = storedPathMap.get(invalidRev.path);
                    cruRevs = null;
                    try {
                        ps.setString(1, invalidRev.sourceName);
                        ps.setString(2, invalidRev.revision);
                        ps.setInt(3, validPath);
                        cruRevs = ps.executeQuery();
                        if (cruRevs.next()) {
                            int realRevId = cruRevs.getInt(1);
                            if (!invalidRevId.equals(realRevId)) {
                                invalidCruRevMap.put(invalidRevId, realRevId);
                            }
                            if (cruRevs.next()) {
                                throw new IllegalStateException("Second record with the same (cru_source_name=" + invalidRev.sourceName + ",cru_revision=" + invalidRev.revision + ",cru_path=" + invalidRev.path + ") was detected. Unable to recover.");
                            }
                            break block10;
                        }
                        CrucibleRevisionTuple validRev = new CrucibleRevisionTuple(null, invalidRev.sourceName, invalidRev.revision, validPath);
                        Integer updatedRevId = (Integer)updatedRevs.get(validRev);
                        if (updatedRevId == null) {
                            revsToUpdate.put(invalidRevId, validPath);
                            updatedRevs.put(validRev, invalidRevId);
                            break block10;
                        }
                        invalidCruRevMap.put(invalidRevId, updatedRevId);
                    }
                    catch (Throwable throwable) {
                        JDBCHelper.closeQuietly(cruRevs);
                        throw throwable;
                        return Pair.newInstance(invalidCruRevMap, revsToUpdate);
                    }
                }
                JDBCHelper.closeQuietly(cruRevs);
            }
        }
        finally {
            JDBCHelper.closeQuietly(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevisionsToCorrectPath(Connection conn, Map<Integer, Integer> revsToUpdate) throws SQLException {
        String sql = "update cru_revision set cru_path = ? where cru_revision_id = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            for (Map.Entry<Integer, Integer> revsToUpdateEntry : revsToUpdate.entrySet()) {
                Integer revId = revsToUpdateEntry.getKey();
                Integer pathId = revsToUpdateEntry.getValue();
                this.logSqlQuery(sql, pathId, revId);
                ps.setInt(1, pathId);
                ps.setInt(2, revId);
                ps.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFRXRevsToCorrectRevision(Connection conn, Map<Integer, Integer> invalidCruRevMap) throws SQLException {
        PreparedStatement psUpdateFrxRevision = null;
        PreparedStatement psDeleteFrDetail = null;
        PreparedStatement psDeleteFeindexMsg = null;
        PreparedStatement psDeleteRevision = null;
        try {
            String sqlUpdateFrxRevision = "update cru_frx_revision set cru_revision = ? where cru_revision = ?";
            String sqlDeleteFrDetail = "delete from cru_fr_detail where cru_revision_id = ?";
            String sqlDeleteFeindexMsg = "delete from cru_feindex_msg where cru_fr_id = ?";
            String sqlDeleteRevision = "delete from cru_revision where cru_revision_id = ?";
            psUpdateFrxRevision = conn.prepareStatement(sqlUpdateFrxRevision);
            psDeleteFrDetail = conn.prepareStatement(sqlDeleteFrDetail);
            psDeleteFeindexMsg = conn.prepareStatement(sqlDeleteFeindexMsg);
            psDeleteRevision = conn.prepareStatement(sqlDeleteRevision);
            for (Map.Entry<Integer, Integer> invalidRev : invalidCruRevMap.entrySet()) {
                Integer fromRevId = invalidRev.getKey();
                Integer toRevId = invalidRev.getValue();
                this.logSqlQuery(sqlUpdateFrxRevision, toRevId, fromRevId);
                psUpdateFrxRevision.setInt(1, toRevId);
                psUpdateFrxRevision.setInt(2, fromRevId);
                psUpdateFrxRevision.executeUpdate();
                this.logSqlQuery(sqlDeleteFrDetail, fromRevId);
                psDeleteFrDetail.setInt(1, fromRevId);
                psDeleteFrDetail.executeUpdate();
                this.logSqlQuery(sqlDeleteFeindexMsg, fromRevId);
                psDeleteFeindexMsg.setInt(1, fromRevId);
                psDeleteFeindexMsg.executeUpdate();
                this.logSqlQuery(sqlDeleteRevision, fromRevId);
                psDeleteRevision.setInt(1, fromRevId);
                psDeleteRevision.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(psDeleteRevision);
            JDBCHelper.closeQuietly(psDeleteFeindexMsg);
            JDBCHelper.closeQuietly(psDeleteFrDetail);
            JDBCHelper.closeQuietly(psUpdateFrxRevision);
            throw throwable;
        }
        JDBCHelper.closeQuietly(psDeleteRevision);
        JDBCHelper.closeQuietly(psDeleteFeindexMsg);
        JDBCHelper.closeQuietly(psDeleteFrDetail);
        JDBCHelper.closeQuietly(psUpdateFrxRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDuplicateStoredPaths(Connection conn, Map<Integer, Integer> storedPathMap) throws SQLException {
        PreparedStatement ps = null;
        try {
            String sql = "delete from cru_stored_path where cru_path_id = ?";
            ps = conn.prepareStatement(sql);
            for (Integer pathId : storedPathMap.keySet()) {
                if (pathId.equals(storedPathMap.get(pathId))) continue;
                this.logSqlQuery(sql, pathId);
                ps.setInt(1, pathId);
                ps.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(ps);
            throw throwable;
        }
        JDBCHelper.closeQuietly(ps);
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        Map<Integer, Integer> storedPathMap = this.getStoredPathMap(conn);
        Map<Integer, CrucibleRevisionTuple> invalidCruRevs = this.getInvalidCruRevs(conn, storedPathMap);
        Pair<Map<Integer, Integer>, Map<Integer, Integer>> processedInvalidCruRevs = this.processInvalidCruRevs(conn, storedPathMap, invalidCruRevs);
        Map<Integer, Integer> invalidCruRevMap = processedInvalidCruRevs.getFirst();
        Map<Integer, Integer> revsToUpdate = processedInvalidCruRevs.getSecond();
        this.updateRevisionsToCorrectPath(conn, revsToUpdate);
        this.updateFRXRevsToCorrectRevision(conn, invalidCruRevMap);
        this.deleteDuplicateStoredPaths(conn, storedPathMap);
    }

    private void logSqlQuery(String sql, Object ... params) {
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("DEDUP: " + DedupeStoredPathUpgradeTask.formatSqlQuery(sql, params)));
        }
    }

    static String formatSqlQuery(String sql, Object ... params) {
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (!(params[i2] instanceof String)) continue;
            params[i2] = "'" + params[i2].toString().replaceAll("'", "\\'") + "'";
        }
        return String.format(sql.replaceAll("\\?", "%s"), params);
    }

    static class CrucibleRevisionTuple {
        final Integer id;
        final String sourceName;
        final String revision;
        final Integer path;

        CrucibleRevisionTuple(Integer id, String sourceName, String revision, Integer path) {
            this.id = id;
            this.sourceName = sourceName;
            this.revision = revision;
            this.path = path;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CrucibleRevisionTuple that = (CrucibleRevisionTuple)o2;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
                return false;
            }
            if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
                return false;
            }
            return !(this.sourceName != null ? !this.sourceName.equals(that.sourceName) : that.sourceName != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
            result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }
}

