/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class DbUtils {
    public static final String SUPPORT_BOOLEAN = "select true from cru_version";
    private static final String SELECT_USERS = "select cru_user_id, cru_user_name from cru_user";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supportBoolean(Connection conn) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SUPPORT_BOOLEAN);
            statement.setFetchSize(1);
            resultSet = statement.executeQuery();
            boolean bl = resultSet.next();
            JDBCHelper.closeQuietly(resultSet, statement);
            return bl;
        }
        catch (SQLException e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            JDBCHelper.closeQuietly(resultSet, statement);
        }
    }

    public static Map<String, Integer> getUsersIdByUsername(Connection conn) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(SELECT_USERS);
            ResultSet rs = statement.executeQuery();
            HashMap userIdByUsername = Maps.newHashMap();
            while (rs.next()) {
                int userId = rs.getInt("cru_user_id");
                String userName = rs.getString("cru_user_name");
                userIdByUsername.put(userName, userId);
            }
            HashMap hashMap = userIdByUsername;
            return hashMap;
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not get all users from cru_user", e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

