/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.LegacyUserProfileManager;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class Data0ToRDBMSAuthorMappingUpgrader {
    private final LegacyUserManager um;
    private final LegacyUserProfileManager upm;

    public Data0ToRDBMSAuthorMappingUpgrader(LegacyUserManager um, LegacyUserProfileManager upm) {
        this.um = um;
        this.upm = upm;
    }

    public void convertMappings(Connection conn) throws DbException, SQLException {
        this.log("Copying existing user to committer/repository mappings to new database");
        PreparedStatement psInsert = conn.prepareStatement("Insert into cru_committer_user_mapping(user_name, repository_name, committer_name) values (?,?,?)");
        PreparedStatement psSelect = conn.prepareStatement("Select * from cru_committer_user_mapping where repository_name=? and committer_name=?");
        PreparedStatement psDelete = conn.prepareStatement("Delete from cru_committer_user_mapping where repository_name=? and committer_name=?");
        Map<String, Map<String, String>> mappings = this.um.getAllLegacyAuthorMappings();
        if (mappings == null) {
            this.log("No existing committer/repository mappings");
        } else {
            for (Map.Entry<String, Map<String, String>> userEntry : mappings.entrySet()) {
                String user = userEntry.getKey();
                for (Map.Entry<String, String> e2 : userEntry.getValue().entrySet()) {
                    this.log("Copying user=[" + user + "], repository=[" + e2.getKey() + "], committerName=[" + e2.getValue() + "]");
                    psSelect.setString(1, e2.getKey());
                    psSelect.setString(2, e2.getValue());
                    ResultSet existing = psSelect.executeQuery();
                    while (existing.next()) {
                        this.log("Deleting existing row for repository=[" + e2.getKey() + "], committerName=[" + e2.getValue() + "] " + existing.getObject(1) + " " + existing.getObject(2) + " " + existing.getObject(3));
                        psDelete.setString(1, e2.getKey());
                        psDelete.setString(2, e2.getValue());
                        psDelete.executeUpdate();
                    }
                    psInsert.setString(1, user);
                    psInsert.setString(2, e2.getKey());
                    psInsert.setString(3, e2.getValue());
                    psInsert.executeUpdate();
                }
            }
            conn.commit();
        }
    }

    private void log(String s2) {
        Logs.APP_LOG.info((Object)s2);
    }

    public void deleteOldMappings() throws DbException {
        for (String user : this.um.getAllUsernames()) {
            this.um.deleteMapping(user);
        }
    }
}

