/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.CommitNotificationEAV;
import com.cenqua.crucible.hibernate.upgrade.DB0CommitNotification;
import com.cenqua.crucible.hibernate.upgrade.DB0HandleUtil;
import com.cenqua.crucible.hibernate.upgrade.UpgradeDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CommitNotificationMigrationUpgradeTask
implements UpgradeTask {
    private static final String INSERT_COMMIT_NOTIFICATION = "insert into cru_commit_notification (cru_commit_notification_id,cru_repository_name,cru_last_checked,cru_changeset_idx_serial,cru_cache_serial_last_rev) values (?,?,?,?,?)";
    private static final String DELETE_COMMIT_NOTIFICATION = "delete from cru_commit_notification";
    private final DB0HandleFactory db0HandleFactory;

    public CommitNotificationMigrationUpgradeTask(DB0HandleFactory db0HandleFactory) {
        this.db0HandleFactory = db0HandleFactory;
    }

    public CommitNotificationMigrationUpgradeTask() {
        this(new UpgradeDB0HandleFactory());
    }

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException, CruDBException {
        Preconditions.checkArgument((boolean)conn.getAutoCommit());
        Logs.APP_LOG.info((Object)"[data0.bin] Migrating commit notification from data0.bin to SQL database.");
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        CommitNotificationMigrationUpgradeTask.sqlDeleteCommitNotifications(conn);
        DB0Handle db0Handle = null;
        try {
            db0Handle = this.db0HandleFactory.getInstance();
            List<DB0CommitNotification> commitNotificationsWithDups = CommitNotificationMigrationUpgradeTask.findCommitNotification(db0Handle);
            List<DB0CommitNotification> commitNotifications = CommitNotificationMigrationUpgradeTask.deduplicate(commitNotificationsWithDups);
            int count = 0;
            for (int i2 = 0; i2 < commitNotifications.size(); ++i2) {
                DB0CommitNotification commitNotification = commitNotifications.get(i2);
                long commitNotificationId = i2;
                try {
                    CommitNotificationMigrationUpgradeTask.sqlInsertCommitNotification(conn, commitNotificationId, commitNotification);
                    ++count;
                    continue;
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)String.format("[data0.bin] Error when inserting commit notification: %s, %s", commitNotification, e2.getMessage()));
                }
            }
            stopwatch.stop();
            Logs.APP_LOG.info((Object)String.format("[data0.bin] Migrated %d from %d commit notification in %s.", count, commitNotificationsWithDups.size(), stopwatch.toString()));
        }
        catch (Exception e3) {
            throw new IllegalStateException("Error during commit notification migration", e3);
        }
        finally {
            DB0HandleUtil.close(db0Handle);
        }
    }

    private static List<DB0CommitNotification> deduplicate(List<DB0CommitNotification> commitNotificationsWithDups) {
        HashMap commitNotificationsByRepo = Maps.newHashMap();
        for (DB0CommitNotification commitNotification : commitNotificationsWithDups) {
            DB0CommitNotification previous = commitNotificationsByRepo.put(commitNotification.getRep(), commitNotification);
            if (previous == null) continue;
            Logs.APP_LOG.warn((Object)String.format("[data0.bin] A duplicated commit notification for repository: %s will be ignored: %s", commitNotification.getRep(), previous));
        }
        return ImmutableList.copyOf(commitNotificationsByRepo.values());
    }

    private static List<DB0CommitNotification> findCommitNotification(DB0Handle db0Handle) {
        return db0Handle.read(new DB0Handle.Reader<List<DB0CommitNotification>>(){

            @Override
            public List<DB0CommitNotification> read(InfinityDbHandle db) throws DbException {
                CommitNotificationEAV commitNotificationEAV = new CommitNotificationEAV(db);
                Set<String> repos = commitNotificationEAV.listRepos();
                ArrayList commitNotifications = Lists.newArrayList();
                for (String repo : repos) {
                    commitNotifications.add(commitNotificationEAV.getCommitNotification(repo));
                }
                return commitNotifications;
            }
        });
    }

    private static void sqlDeleteCommitNotifications(Connection conn) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(DELETE_COMMIT_NOTIFICATION);
            statement.executeUpdate();
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not clean group tables", e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }

    private static void sqlInsertCommitNotification(Connection conn, long id, DB0CommitNotification commitNotification) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(INSERT_COMMIT_NOTIFICATION);
            statement.setLong(1, id);
            statement.setString(2, commitNotification.getRep());
            statement.setLong(3, commitNotification.getLastChecked());
            statement.setLong(4, commitNotification.getChangesetIndexSerial());
            statement.setLong(5, commitNotification.getCacheSerialOfLastRevision());
            if (statement.executeUpdate() == 0) {
                throw new IllegalStateException(String.format("Commit notification could not be created: %s", commitNotification));
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Could not migrate commit notification: %s", commitNotification), e2);
        }
        finally {
            JDBCHelper.closeQuietly(statement);
        }
    }
}

