/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.cenqua.fisheye.util.Pair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CommentReadStatusUpgradeTask
implements UpgradeTask {
    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) throws SQLException {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("select cru_comment.cru_comment_id, cru_comment.cru_user_id from cru_comment_read_status right join cru_comment on cru_comment = cru_comment_id where cru_read is null;");
        ResultSet resultSet = null;
        ArrayList<Pair<Integer, Integer>> comments = new ArrayList<Pair<Integer, Integer>>();
        try {
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                int toId;
                int fromId = resultSet.getInt(1);
                if (fromId == (toId = resultSet.getInt(2))) continue;
                comments.add(Pair.newInstance(fromId, toId));
            }
        }
        finally {
            JDBCHelper.closeQuietly(resultSet, ps);
        }
        int nextStatusId = 0;
        ps = conn.prepareStatement("select max(cru_comment_read_status_id) from cru_comment_read_status;");
        try {
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                nextStatusId = resultSet.getInt(1) + 1;
            }
        }
        finally {
            JDBCHelper.closeQuietly(resultSet, ps);
        }
        for (Pair pair : comments) {
            ps = conn.prepareStatement("insert into cru_comment_read_status values (?, true, ?, ?);");
            try {
                ps.setInt(1, nextStatusId);
                ps.setInt(2, (Integer)pair.getSecond());
                ps.setInt(3, (Integer)pair.getFirst());
                if (ps.executeUpdate() != 1) {
                    Logs.APP_LOG.warn((Object)"Failed to insert comment read status during upgrade (Fixing pre 2.0 data). Continuing anyway.");
                }
            }
            finally {
                JDBCHelper.closeQuietly(resultSet, ps);
            }
            ++nextStatusId;
        }
    }
}

