/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Zipper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class CachedTablesUpgrade
implements UpgradeTask {
    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) {
        File cruData = new File(AppConfig.getInstanceDir(), "var/data/crudb/crucible.data");
        if (cruData.exists()) {
            try {
                CachedTablesUpgrade.backupData(28);
            }
            catch (IOException e2) {
                throw new RuntimeException("Error backing up db 28", e2);
            }
            File cruProps = new File(AppConfig.getInstanceDir(), "var/data/crudb/crucible.properties");
            if (cruProps.exists()) {
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    Properties props = new Properties();
                    in = new FileInputStream(cruProps);
                    props.load(in);
                    props.setProperty("hsqldb.default_table_type", "memory");
                    out = new FileOutputStream(cruProps);
                    props.store(out, null);
                }
                catch (IOException e3) {
                    try {
                        throw new RuntimeException("Error changing crucible.properties", e3);
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(in);
                        IOHelper.close(out);
                        throw throwable;
                    }
                }
                IOHelper.close(in);
                IOHelper.close(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backupData(int reqVersion) throws IOException {
        File backupDir = new File(AppConfig.getInstanceDir(), "backup");
        SimpleDateFormat format = new SimpleDateFormat("yyyyddMMHHmmss");
        String filename = "backup_upgrade_" + reqVersion + "_" + format.format(new Date());
        File backupFile = new File(backupDir, filename + ".zip");
        Logs.APP_LOG.info((Object)("Backing up crucible data to: " + backupFile.getName()));
        IOHelper.mkdirs(backupFile.getParentFile());
        IOHelper.createNewFile(backupFile);
        try {
            Zipper zipper = new Zipper();
            zipper.add(new Path("var/data"), AppConfig.getVarDataDir(), "crudb");
            zipper.add(new Path("var/data"), AppConfig.getVarDataDir(), "uploads");
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(backupFile));
                zipper.zip(out);
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                throw throwable;
            }
            IOHelper.close(out);
            String msg = "Data backed up to " + backupFile.getAbsolutePath();
            Logs.APP_LOG.info((Object)msg);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            throw e2;
        }
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) {
        Logs.APP_LOG.error((Object)"The upgrade/conversion from cached tables failed. You will need to recover the backup of your crucible database by unzipping the backup file and copying the crudb directory to FISHEYE_INST/var/data/");
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) {
        File f2 = new File(AppConfig.getInstanceDir(), "var/data/crudb/crucible.data");
        IOHelper.deleteFile(f2);
        f2 = new File(AppConfig.getInstanceDir(), "var/data/crudb/crucible.backup");
        IOHelper.deleteFile(f2);
    }
}

