/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BumpDbVersionUpgradeTask
implements UpgradeTask {
    public static final int JAVA_BASED_UPGRADE = 84;
    private final int upgradingFrom;

    public BumpDbVersionUpgradeTask(int upgradingFrom) {
        this.upgradingFrom = upgradingFrom;
    }

    @Override
    public void beforeUpgradeScript(Connection conn, DBType type) {
    }

    @Override
    public void upgradeFailed(Connection conn, DBType type) {
    }

    @Override
    public void afterUpgradeScript(Connection conn, DBType type) throws SQLException {
        this.bumpVersionNumberUp(conn);
    }

    private void bumpVersionNumberUp(Connection conn) throws SQLException {
        if (this.upgradingFrom < 84) {
            return;
        }
        PreparedStatement ps = conn.prepareStatement("UPDATE cru_version SET cru_version=cru_version+1 WHERE cru_version_id=1 AND cru_version=?");
        try {
            ps.setInt(1, this.upgradingFrom);
            ps.execute();
            if (1 == ps.getUpdateCount()) {
                Logs.APP_LOG.info((Object)("Database upgrade from version " + this.upgradingFrom + " is successful"));
            } else {
                Logs.APP_LOG.warn((Object)("Failed to record database upgrade (from version " + this.upgradingFrom + ")"));
            }
        }
        finally {
            JDBCHelper.closeQuietly(ps);
        }
    }
}

