/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.cenqua.crucible.hibernate.trackingstatements.TrackingStatementsConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class TrackingStatementsConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    protected final ConnectionProvider connectionProvider;
    private final boolean detectUnclosedStatements;

    public TrackingStatementsConnectionProvider(ConnectionProvider connectionProvider, boolean detectUnclosedStatements) {
        this.connectionProvider = connectionProvider;
        this.detectUnclosedStatements = detectUnclosedStatements;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.connectionProvider.getConnection();
        return new TrackingStatementsConnection(connection, this.detectUnclosedStatements);
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (!(connection instanceof TrackingStatementsConnection)) {
            throw new IllegalStateException(String.format("TrackingStatementsConnectionProvider.closeConnection with connection of type: %s, connection: %s", connection.getClass().getCanonicalName(), connection));
        }
        TrackingStatementsConnection trackingStatementsConnection = (TrackingStatementsConnection)connection;
        trackingStatementsConnection.close(false);
        this.connectionProvider.closeConnection(trackingStatementsConnection.getInternalConnection());
    }

    public boolean supportsAggressiveRelease() {
        return this.connectionProvider.supportsAggressiveRelease();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.connectionProvider.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.connectionProvider.unwrap(unwrapType);
    }

    public void configure(Map configurationValues) {
        ((Configurable)this.connectionProvider).configure(configurationValues);
    }

    public void stop() {
        ((Stoppable)this.connectionProvider).stop();
    }
}

