/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.cenqua.crucible.hibernate.trackingstatements.CanUntrackStatement;
import com.cenqua.crucible.hibernate.trackingstatements.TrackingStatementFactory;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class TrackingStatementsConnection
implements CanUntrackStatement,
Connection {
    protected static final String UNCLOSED_LOG_ERROR_MESSAGE = "Statement was not properly closed before this connection was closed. Stack trace when statement was created: %s";
    private final Connection internalConnection;
    private final Cache<Statement, Optional<String>> trackedStatementWithStackTrace;
    private final boolean detectUnclosedStatements;

    public TrackingStatementsConnection(Connection connection, boolean detectUnclosedStatements) {
        this.internalConnection = connection;
        this.detectUnclosedStatements = detectUnclosedStatements;
        this.trackedStatementWithStackTrace = CacheBuilder.newBuilder().weakKeys().build();
    }

    public Connection getInternalConnection() {
        return this.internalConnection;
    }

    @Override
    public void untrackStatement(Statement statement) {
        this.trackedStatementWithStackTrace.invalidate((Object)statement);
    }

    public long numberOfTrackedStatements() {
        return this.trackedStatementWithStackTrace.size();
    }

    private void closeTrackedStatements() throws SQLException {
        for (Map.Entry statementEntry : this.trackedStatementWithStackTrace.asMap().entrySet()) {
            Statement statement = (Statement)statementEntry.getKey();
            if (statement.isClosed()) continue;
            statement.close();
            Optional stackTrace = (Optional)statementEntry.getValue();
            if (!this.detectUnclosedStatements || !stackTrace.isPresent()) continue;
            Logs.APP_LOG.warn((Object)String.format(UNCLOSED_LOG_ERROR_MESSAGE, stackTrace.get()));
        }
        this.trackedStatementWithStackTrace.invalidateAll();
    }

    private Optional<String> maybeCaptureStackTrace() {
        if (this.detectUnclosedStatements) {
            return Optional.of((Object)Throwables.getStackTraceAsString((Throwable)new Throwable()));
        }
        return Optional.absent();
    }

    private Statement trackStatement(Statement statement) {
        Statement trackingStatement = TrackingStatementFactory.createTrackingStatement(this, statement);
        this.trackedStatementWithStackTrace.put((Object)trackingStatement, this.maybeCaptureStackTrace());
        return trackingStatement;
    }

    private CallableStatement trackCallableStatement(CallableStatement callableStatement) {
        CallableStatement trackingCallableStatement = TrackingStatementFactory.createTrackingCallableStatement(this, callableStatement);
        this.trackedStatementWithStackTrace.put((Object)trackingCallableStatement, this.maybeCaptureStackTrace());
        return trackingCallableStatement;
    }

    private PreparedStatement trackPreparedStatement(PreparedStatement preparedStatement) {
        PreparedStatement trackingPreparedStatement = TrackingStatementFactory.createTrackingPreparedStatement(this, preparedStatement);
        this.trackedStatementWithStackTrace.put((Object)trackingPreparedStatement, this.maybeCaptureStackTrace());
        return trackingPreparedStatement;
    }

    public void close(boolean closeInternalConnection) throws SQLException {
        this.closeTrackedStatements();
        if (closeInternalConnection) {
            this.internalConnection.close();
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement statement = this.internalConnection.createStatement();
        return this.trackStatement(statement);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.internalConnection.createStatement(resultSetType, resultSetConcurrency);
        return this.trackStatement(statement);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement = this.internalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.trackStatement(statement);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStatement = this.internalConnection.prepareCall(sql);
        return this.trackCallableStatement(callableStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement callableStatement = this.internalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        return this.trackCallableStatement(callableStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callableStatement = this.internalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.trackCallableStatement(callableStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql, autoGeneratedKeys);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql, columnIndexes);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement preparedStatement = this.internalConnection.prepareStatement(sql, columnNames);
        return this.trackPreparedStatement(preparedStatement);
    }

    @Override
    public String nativeSQL(String s2) throws SQLException {
        return this.internalConnection.nativeSQL(s2);
    }

    @Override
    public void setAutoCommit(boolean b2) throws SQLException {
        this.internalConnection.setAutoCommit(b2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.internalConnection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.internalConnection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.internalConnection.rollback();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.internalConnection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.internalConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean b2) throws SQLException {
        this.internalConnection.setReadOnly(b2);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.internalConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String s2) throws SQLException {
        this.internalConnection.setCatalog(s2);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.internalConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int i2) throws SQLException {
        this.internalConnection.setTransactionIsolation(i2);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.internalConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.internalConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.internalConnection.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.internalConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
        this.internalConnection.setTypeMap(stringClassMap);
    }

    @Override
    public void setHoldability(int i2) throws SQLException {
        this.internalConnection.setHoldability(i2);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.internalConnection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.internalConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String s2) throws SQLException {
        return this.internalConnection.setSavepoint(s2);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.internalConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.internalConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.internalConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.internalConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.internalConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.internalConnection.createSQLXML();
    }

    @Override
    public boolean isValid(int i2) throws SQLException {
        return this.internalConnection.isValid(i2);
    }

    @Override
    public void setClientInfo(String s2, String s22) throws SQLClientInfoException {
        this.internalConnection.setClientInfo(s2, s22);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.internalConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String s2) throws SQLException {
        return this.internalConnection.getClientInfo(s2);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.internalConnection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String s2, Object[] objects) throws SQLException {
        return this.internalConnection.createArrayOf(s2, objects);
    }

    @Override
    public Struct createStruct(String s2, Object[] objects) throws SQLException {
        return this.internalConnection.createStruct(s2, objects);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.internalConnection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.internalConnection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.internalConnection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.internalConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.internalConnection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return this.internalConnection.unwrap(tClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return this.internalConnection.isWrapperFor(aClass);
    }
}

