/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.cenqua.crucible.hibernate.trackingstatements.CanUntrackStatement;
import com.google.common.base.Objects;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class TrackingStatementFactory {
    private static <T extends Statement> InvocationHandler createInvocationHandler(final CanUntrackStatement canUntrackStatement, final T statement) {
        return new AbstractInvocationHandler(){

            protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close")) {
                    canUntrackStatement.untrackStatement((Statement)proxy);
                }
                try {
                    return method.invoke((Object)statement, args);
                }
                catch (InvocationTargetException e2) {
                    throw e2.getCause();
                }
            }

            public String toString() {
                return Objects.toStringHelper((Object)((Object)this)).add("canUntrackStatement", (Object)canUntrackStatement).add("statement", (Object)statement).toString();
            }
        };
    }

    public static Statement createTrackingStatement(CanUntrackStatement canUntrackStatement, Statement statement) {
        return (Statement)Reflection.newProxy(Statement.class, (InvocationHandler)TrackingStatementFactory.createInvocationHandler(canUntrackStatement, statement));
    }

    public static PreparedStatement createTrackingPreparedStatement(CanUntrackStatement canUntrackStatement, PreparedStatement preparedStatement) {
        return (PreparedStatement)Reflection.newProxy(PreparedStatement.class, (InvocationHandler)TrackingStatementFactory.createInvocationHandler(canUntrackStatement, preparedStatement));
    }

    public static CallableStatement createTrackingCallableStatement(CanUntrackStatement canUntrackStatement, CallableStatement callableStatement) {
        return (CallableStatement)Reflection.newProxy(CallableStatement.class, (InvocationHandler)TrackingStatementFactory.createInvocationHandler(canUntrackStatement, callableStatement));
    }
}

