/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateBonceCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -5236029951415598543L;
    protected static final String CONFIG_CONNECTION_DRIVER_CLASS = "hibernate.connection.driver_class";
    protected static final String CONFIG_CONNECTION_PASSWORD = "hibernate.connection.password";
    protected static final String CONFIG_CONNECTION_USERNAME = "hibernate.connection.username";
    protected static final String CONFIG_CONNECTION_URL = "hibernate.connection.url";
    protected static final String CONFIG_CONNECTION_DRIVER_CLASS_ALTERNATE = "javax.persistence.jdbc.driver";
    protected static final String CONFIG_CONNECTION_PASSWORD_ALTERNATE = "javax.persistence.jdbc.password";
    protected static final String CONFIG_CONNECTION_USERNAME_ALTERNATE = "javax.persistence.jdbc.user";
    protected static final String CONFIG_CONNECTION_URL_ALTERNATE = "javax.persistence.jdbc.url";
    private BoneCP pool;
    private Integer isolation;
    private boolean autocommit;
    private ClassLoader classLoader;
    private BoneCPConfig config;
    private static Logger logger = LoggerFactory.getLogger(HibernateBonceCPConnectionProvider.class);

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        try {
            this.config = new BoneCPConfig(props);
            String url = props.getProperty(CONFIG_CONNECTION_URL);
            String username = props.getProperty(CONFIG_CONNECTION_USERNAME);
            String password = props.getProperty(CONFIG_CONNECTION_PASSWORD);
            String driver = props.getProperty(CONFIG_CONNECTION_DRIVER_CLASS);
            if (url == null) {
                url = props.getProperty(CONFIG_CONNECTION_URL_ALTERNATE);
            }
            if (username == null) {
                username = props.getProperty(CONFIG_CONNECTION_USERNAME_ALTERNATE);
            }
            if (password == null) {
                password = props.getProperty(CONFIG_CONNECTION_PASSWORD_ALTERNATE);
            }
            if (driver == null) {
                driver = props.getProperty(CONFIG_CONNECTION_DRIVER_CLASS_ALTERNATE);
            }
            if (url != null) {
                this.config.setJdbcUrl(url);
            }
            if (username != null) {
                this.config.setUsername(username);
            }
            if (password != null) {
                this.config.setPassword(password);
            }
            this.isolation = ConfigurationHelper.getInteger((String)"hibernate.connection.isolation", (Map)props);
            this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)props);
            logger.debug(this.config.toString());
            if (driver != null && !driver.trim().equals("")) {
                this.loadClass(driver);
            }
            if (this.config.getConnectionHookClassName() != null) {
                Object hookClass = this.loadClass(this.config.getConnectionHookClassName()).newInstance();
                this.config.setConnectionHook((ConnectionHook)hookClass);
            }
            this.pool = this.createPool(this.config);
        }
        catch (Exception e2) {
            throw new HibernateException((Throwable)e2);
        }
    }

    protected Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(clazz);
        }
        return Class.forName(clazz, true, this.classLoader);
    }

    protected BoneCP createPool(BoneCPConfig config) {
        try {
            return new BoneCP(config);
        }
        catch (SQLException e2) {
            throw new HibernateException((Throwable)e2);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.pool.getConnection();
        try {
            if (this.isolation != null && connection.getTransactionIsolation() != this.isolation.intValue()) {
                connection.setTransactionIsolation(this.isolation);
            }
            if (connection.getAutoCommit() != this.autocommit) {
                connection.setAutoCommit(this.autocommit);
            }
            return connection;
        }
        catch (SQLException e2) {
            try {
                connection.close();
            }
            catch (Exception e22) {
                logger.warn("Setting connection properties failed and closing this connection failed again", (Throwable)e2);
            }
            throw e2;
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    protected BoneCPConfig getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || HibernateBonceCPConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || HibernateBonceCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    private Properties mapToProperties(Map<String, String> map) {
        Properties p2 = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            p2.put(entry.getKey(), entry.getValue());
        }
        return p2;
    }

    public void configure(Map configurationValues) {
        this.configure(this.mapToProperties(configurationValues));
    }

    public void stop() {
        this.close();
    }

    public void close() {
        this.pool.shutdown();
    }
}

