/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.HibernateUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WithSessionAspect
implements Ordered {
    @Pointcut(value="@within(com.cenqua.crucible.hibernate.WithSession)")
    private void classAnnotatedWithWithSession() {
    }

    @Pointcut(value="execution(@com.cenqua.crucible.hibernate.WithSession * *(..))")
    private void methodAnnotatedWithWithSession() {
    }

    @Pointcut(value="execution(public * *(..))")
    private void anyPublicOperation() {
    }

    @Pointcut(value="within(com.atlassian.crucible.spi.impl..*) || within(com.atlassian.fisheye.spi.impl..*) || within(com.atlassian.fisheye.spi.services..*) || within(com.atlassian.fisheye.spi.admin.impl..*)")
    private void serviceBean() {
    }

    @Pointcut(value="within(com.atlassian.crowd.support.SupportInformationService+)")
    private void crowdServiceBean() {
    }

    @Pointcut(value="within(com.atlassian.fisheye.spi.TxTemplate+)")
    private void ignored() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="!ignored() && (classAnnotatedWithWithSession() || methodAnnotatedWithWithSession() || serviceBean() || crowdServiceBean()) && anyPublicOperation()")
    public Object doCloseSession(ProceedingJoinPoint method) throws Throwable {
        boolean hasSession = HibernateUtil.isCurrentSession();
        try {
            Object object = method.proceed();
            return object;
        }
        finally {
            if (!hasSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    public int getOrder() {
        return 777;
    }
}

