/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class StringClobType
implements UserType {
    private static final int READ_BUFFER_SIZE = 8192;

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x2, Object y2) throws HibernateException {
        return x2 == y2 || x2 != null && y2 != null && x2.equals(y2);
    }

    public int hashCode(Object x2) throws HibernateException {
        return x2.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Reader reader = rs.getCharacterStream(names[0]);
        if (reader == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            char[] charbuf = new char[8192];
            int i2 = reader.read(charbuf);
            while (i2 > 0) {
                sb.append(charbuf, 0, i2);
                i2 = reader.read(charbuf);
            }
        }
        catch (IOException e2) {
            throw new SQLException(e2.getMessage());
        }
        return sb.toString();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            StringReader r2 = new StringReader((String)value);
            st.setCharacterStream(index, (Reader)r2, ((String)value).length());
        } else {
            st.setNull(index, this.sqlTypes()[0]);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, null);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (String)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

