/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.fisheye.logging.Logs;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;

public class SessionTracker {
    private Map<Session, RuntimeException> sessionCreationContexts = new ConcurrentHashMap<Session, RuntimeException>();

    public void sessionOpened(Session s2) {
        this.sessionCreationContexts.put(s2, new RuntimeException());
    }

    public void sessionClosed(Session s2) {
        this.sessionCreationContexts.remove(s2);
    }

    public void reportOpenSessions(Set<Session> sessions) {
        if (sessions.isEmpty()) {
            Logs.APP_LOG.error((Object)"reportOpenSessions(): called with no open sessions.");
        }
        for (Session s2 : sessions) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.sessionCreationContexts.get(s2).printStackTrace(pw);
            pw.close();
            Logs.APP_LOG.error((Object)("reportOpenSessions(): Session started at " + sw.toString() + " still open"));
        }
    }
}

