/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.fisheye.event.FisheyeEventPublisher;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.commons.lang.exception.Nestable;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SessionState {
    private final Session session;
    private int txDepth;
    private Transaction tx;
    @Nullable
    private Throwable txBeginStacktrace;
    private Queue<FisheyeEventPublisher.EventPublication> txEventQueue = Queues.newArrayDeque();

    SessionState(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTx() {
        return this.tx;
    }

    @Nullable
    public Throwable getTxBeginStacktrace() {
        return this.txBeginStacktrace;
    }

    public void beginTx() {
        if (this.tx == null || this.tx.wasCommitted() || this.tx.wasRolledBack()) {
            if (this.tx != null) {
                if (this.tx.wasCommitted()) {
                    Logs.APP_LOG.warn((Object)"Begining a new transaction on an already commited existing transaction");
                }
                if (this.tx.wasRolledBack()) {
                    Logs.APP_LOG.warn((Object)"Begining a new transaction on an already commited existing transaction");
                }
            }
            this.tx = this.session.beginTransaction();
            this.pushTxBeginStacktrace(0);
            this.txDepth = 1;
        } else {
            this.pushTxBeginStacktrace(this.txDepth);
            ++this.txDepth;
        }
    }

    private void pushTxBeginStacktrace(int depth) {
        this.txBeginStacktrace = Logs.isDebugMode() ? new Throwable("(Stack trace at transaction depth " + depth + " start)", this.txBeginStacktrace) : null;
    }

    private void popTxBeginStacktrace() {
        this.txBeginStacktrace = this.txBeginStacktrace != null ? this.txBeginStacktrace.getCause() : null;
    }

    private void resetTxBeginStacktrace() {
        this.txBeginStacktrace = null;
    }

    @Deprecated
    public void ensureTx() {
        if (this.tx == null || !this.tx.isActive()) {
            this.beginTx();
        }
    }

    public void commitTx() throws HibernateException {
        if (this.tx == null) {
            return;
        }
        if (this.txDepth > 1) {
            this.popTxBeginStacktrace();
            --this.txDepth;
            return;
        }
        this.commitAllTx();
    }

    public void commitAllTx() throws HibernateException {
        Transaction currentTx = this.tx;
        this.tx = null;
        this.txDepth = 0;
        this.resetTxBeginStacktrace();
        try {
            SessionState.commit(currentTx);
        }
        catch (RuntimeException e2) {
            if (e2 instanceof Nestable) {
                Nestable he = (Nestable)e2;
                for (int i2 = 0; i2 < he.getMessages().length; ++i2) {
                    String s2 = he.getMessages()[i2];
                    Logs.APP_LOG.error((Object)("Commit fail msg-" + i2 + ":" + s2));
                }
            }
            Logs.APP_LOG.error((Object)"Commit failed. Rolling back.", (Throwable)e2);
            SessionState.rollback(currentTx);
            throw e2;
        }
    }

    public void forceRollbackTx() throws HibernateException {
        Transaction currentTx = this.tx;
        this.tx = null;
        this.txDepth = 0;
        this.resetTxBeginStacktrace();
        SessionState.rollback(currentTx);
    }

    public void rollbackIfNotCommitedTx() throws HibernateException {
        if (this.txDepth > 0) {
            return;
        }
        Transaction currentTx = this.tx;
        this.tx = null;
        this.txDepth = 0;
        this.resetTxBeginStacktrace();
        SessionState.rollback(currentTx);
    }

    private static void rollback(Transaction tx) {
        if (tx != null) {
            Logs.APP_LOG.debug((Object)("Trying to rollback transaction: " + tx));
            if (!tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.rollback();
                Logs.APP_LOG.warn((Object)("Rolled back transaction: " + tx));
            }
        }
    }

    private static void commit(Transaction tx) throws HibernateException {
        if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
            tx.commit();
        }
    }

    public void enqueueEvent(FisheyeEventPublisher.EventPublication event) {
        this.txEventQueue.add(event);
    }

    public Iterable<FisheyeEventPublisher.EventPublication> drainQueuedEvents() {
        ImmutableList eventPublications = ImmutableList.copyOf(this.txEventQueue);
        this.txEventQueue.clear();
        return eventPublications;
    }
}

