/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fisheye.model.ChangesetComment;
import com.cenqua.crucible.hibernate.EmptyHibernateListener;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.ChangesetCommentIndexer;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class ReviewItemIndexListener
extends EmptyHibernateListener {
    public static final Set<String> INDEXED_LOGITEM_ACTIONS = ImmutableSet.of((Object)LogAction.REVIEW_REVIEWER_ADDED_MID_REVIEW.getKey(), (Object)LogAction.REVIEW_REVIEWER_REMOVED_MID_REVIEW.getKey());
    private static final ImmutableSet<String> PROPERTIES_TO_IGNORE = ImmutableSet.of((Object)"timeSpent", (Object)"ruc", (Object)"lastReadTime", (Object)"fileReadStatus");
    private ReviewItemIndexer indexer;
    private Changes changes = new Changes();

    @Override
    public void onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.check(entity, currentState, previousState, propertyNames);
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.check(entity, state, null, propertyNames);
    }

    @Override
    public void onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.check(entity, state, null, propertyNames);
    }

    @Override
    public void afterTransactionCommit(Transaction tx) {
        if (!this.changes.isEmpty()) {
            Changes currentChanges = this.changes;
            this.changes = new Changes();
            this.getIndexer().index(currentChanges);
        }
    }

    @Override
    public void afterTransactionRollback(Transaction tx) {
        this.changes = new Changes();
    }

    private ReviewItemIndexer getIndexer() {
        if (this.indexer == null) {
            this.indexer = SpringContext.getComponent(ReviewItemIndexer.class, "reviewItemIndexer");
        }
        return this.indexer;
    }

    private void check(Object entity, Object[] currentState, Object[] previousState, String[] propertyNames) {
        if (entity instanceof Comment) {
            Comment c2 = (Comment)entity;
            ReviewChanges reviewChanges = this.changes.getChangesForReview(c2.getReviewId());
            reviewChanges.getCommentIds().add((Object)c2.getId());
            reviewChanges.setLastModified(c2.getCreateDateTime());
        } else if (entity instanceof FRXRevision) {
            FRXRevision frx = (FRXRevision)entity;
            this.changes.getChangesForReview(frx.getFrx().getReviewId()).setReviewChanged(true);
        } else if (entity instanceof StateChangeLog) {
            StateChangeLog scl = (StateChangeLog)entity;
            int sclId = scl.getId();
            ReviewChanges reviewChanges = this.changes.getChangesForReview(scl.getReviewId());
            reviewChanges.getStateChangeLogIds().add(sclId);
            reviewChanges.setLastModified(scl.getDateTimeStamp());
        } else if (entity instanceof Review) {
            Review review = (Review)entity;
            int reviewId = review.getId();
            this.changes.getChangesForReview(reviewId).setReviewChanged(true);
        } else if (entity instanceof ReviewParticipant) {
            if (previousState == null || this.isChangesOtherThan(currentState, previousState, propertyNames, (Set<String>)PROPERTIES_TO_IGNORE)) {
                ReviewParticipant reviewParticipant = (ReviewParticipant)entity;
                int rpId = reviewParticipant.getId();
                this.changes.getChangesForReview(reviewParticipant.getReviewId()).getReviewParticipants().add(rpId);
            }
        } else if (entity instanceof LogItem) {
            LogItem logItem = (LogItem)entity;
            ReviewChanges reviewChanges = this.changes.getChangesForReview(logItem.getReviewId());
            reviewChanges.setLastModified(logItem.getCreateDateTime());
            if (INDEXED_LOGITEM_ACTIONS.contains(logItem.getAction())) {
                reviewChanges.getLogItemIds().add((Object)logItem.getId());
            }
        } else if (entity instanceof ChangesetComment) {
            try {
                ChangesetCommentIndexer changesetCommentIndexer = new ChangesetCommentIndexer(null);
                changesetCommentIndexer.indexComment(((ChangesetComment)entity).toInfo());
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("Error indexing changeset comment " + entity), (Throwable)e2);
            }
        }
    }

    private boolean isChangesOtherThan(Object[] currentState, Object[] previousState, String[] propertyNames, Set<String> propertiesToIgnore) {
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            if (propertiesToIgnore.contains(propertyNames[i2]) || this.equal(currentState[i2], previousState[i2])) continue;
            return true;
        }
        return false;
    }

    private boolean equal(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public static class Changes {
        private Int2ObjectMap<ReviewChanges> reviews = new Int2ObjectOpenHashMap();

        public boolean isEmpty() {
            return this.reviews.isEmpty();
        }

        public Int2ObjectMap<ReviewChanges> getChangesForReviews() {
            return this.reviews;
        }

        public ReviewChanges getChangesForReview(int id) {
            ReviewChanges rc = (ReviewChanges)this.reviews.get(id);
            if (rc == null) {
                rc = new ReviewChanges();
                this.reviews.put(id, (Object)rc);
            }
            return rc;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Changes{");
            for (Map.Entry change : this.getChangesForReviews().entrySet()) {
                builder.append(change.getKey()).append("=>").append(change.getValue()).append("\n");
            }
            builder.append("}");
            return builder.toString();
        }
    }

    public static class ReviewChanges {
        private IntSet commentIds = new IntOpenHashSet();
        private IntSet stateChangeLogIds = new IntOpenHashSet();
        private IntSet reviewParticipants = new IntOpenHashSet();
        private IntSet logItemIds = new IntOpenHashSet();
        private boolean reviewChanged;
        private Long lastModified;

        public IntSet getCommentIds() {
            return this.commentIds;
        }

        public IntSet getStateChangeLogIds() {
            return this.stateChangeLogIds;
        }

        public IntSet getReviewParticipants() {
            return this.reviewParticipants;
        }

        public boolean isReviewChanged() {
            return this.reviewChanged;
        }

        public void setReviewChanged(boolean reviewChanged) {
            this.reviewChanged = reviewChanged;
        }

        public IntSet getLogItemIds() {
            return this.logItemIds;
        }

        public String toString() {
            return "ReviewChanges{commentIds=" + this.commentIds + ", stateChangeLogIds=" + this.stateChangeLogIds + ", reviewParticipants=" + this.reviewParticipants + ", logItemIds=" + this.logItemIds + ", reviewChanged=" + this.reviewChanged + '}';
        }

        public void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }

        public Long getLastModified() {
            return this.lastModified;
        }
    }
}

