/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.EmptyHibernateListener;
import java.io.Serializable;
import org.hibernate.type.Type;

public class PropertyLengthCheckerListener
extends EmptyHibernateListener {
    @Override
    public void onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.checkEntity(entity, currentState, propertyNames, types);
    }

    @Override
    public void onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.checkEntity(entity, state, propertyNames, types);
    }

    private void checkEntity(Object entity, Object[] currentState, String[] propertyNames, Type[] types) {
        for (int i2 = 0; i2 < types.length; ++i2) {
            Class<?> persistedClass;
            Integer maxLength;
            if (!types[i2].getName().equals("string") || !(currentState[i2] instanceof String) || (maxLength = Config.getLength(persistedClass = entity.getClass(), propertyNames[i2])) == null || maxLength >= ((String)currentState[i2]).length()) continue;
            throw new IllegalArgumentException("The value '" + currentState[i2] + "' for the property '" + propertyNames[i2] + "' is too long. It should have a maximum length of " + maxLength);
        }
    }
}

