/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DialectUtils;

public class OracleDialectUtils
extends DialectUtils {
    protected static final String NULL_COMPARISON_SENTINEL = "'<%cru_null%>'";

    protected OracleDialectUtils() {
    }

    @Override
    public String getClobsEqualExpression(String colName, String expression) {
        if (colName == null) {
            throw new NullPointerException("Column name must not be null");
        }
        if ("null".equalsIgnoreCase(String.valueOf(expression).trim())) {
            return String.format("%s is null", colName);
        }
        return String.format("DBMS_LOB.compare(nvl(%s, %s), nvl(%s, %s)) = 0", colName, NULL_COMPARISON_SENTINEL, expression, NULL_COMPARISON_SENTINEL);
    }
}

