/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControlConnectionProvider;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class OracleDBControl
extends DefaultDBControl {
    private static final Pattern DROP_TABLE_REGEX = Pattern.compile("^drop table.*$", 2);

    public OracleDBControl(DatabaseConfig dbConfig, DBControlConnectionProvider connectionProvider, File sqlDir) {
        super(dbConfig, connectionProvider, sqlDir);
    }

    @Override
    protected String processCommand(String sqlCommand) {
        String command;
        String string = command = sqlCommand.charAt(sqlCommand.length() - 1) == ';' ? sqlCommand.substring(0, sqlCommand.length() - 1) : sqlCommand;
        if (DROP_TABLE_REGEX.matcher(command).matches()) {
            command = command + " purge";
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableUniqueConstraintsWithAutoIndexes(boolean enable) throws CruDBException {
        Connection connection = this.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                this.enableUniqueConstraintsWithAutoIndexes(enable, this.fetchTablesToColumnConstraints(connection), connection);
            }
            catch (SQLException e2) {
                throw new CruDBException("Failed to temporarily " + (enable ? "enable" : "disable") + " the uniqueness constraints", e2);
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableUniqueConstraintsWithAutoIndexes(boolean enable, Map<String, Map<String, List<String>>> tablesToColumnConstraints, Connection connection) throws SQLException {
        for (Map.Entry<String, Map<String, List<String>>> tableEntry : tablesToColumnConstraints.entrySet()) {
            String tableName = tableEntry.getKey();
            for (Map.Entry<String, List<String>> constraintEntry : tableEntry.getValue().entrySet()) {
                String constraintName = constraintEntry.getKey();
                List<String> columnNames = constraintEntry.getValue();
                try (Statement updateStatement = connection.createStatement();){
                    updateStatement.executeUpdate("alter table " + tableName + " " + (enable ? "enable" : "disable") + " unique (" + StringUtils.join(columnNames, (String)",").toString() + ")");
                }
            }
        }
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, List<String>>> fetchTablesToColumnConstraints(Connection connection) throws SQLException {
        HashMap<String, Map<String, List<String>>> tablesToColumnConstraints = new HashMap<String, Map<String, List<String>>>();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select c.table_name, a.constraint_name, a.column_name from all_cons_columns a join all_constraints c on a.constraint_name = c.constraint_name where c.table_name like 'CRU_%' and c.constraint_type = 'U' order by c.table_name, a.constraint_name, a.position");
            while (resultSet.next()) {
                LinkedList<String> columns;
                String tableName = resultSet.getString(1);
                String constraintName = resultSet.getString(2);
                String columnName = resultSet.getString(3);
                HashMap<String, LinkedList<String>> constraints = (HashMap<String, LinkedList<String>>)tablesToColumnConstraints.get(tableName);
                if (constraints == null) {
                    constraints = new HashMap<String, LinkedList<String>>();
                    tablesToColumnConstraints.put(tableName, constraints);
                }
                if ((columns = (LinkedList<String>)constraints.get(constraintName)) == null) {
                    columns = new LinkedList<String>();
                    constraints.put(constraintName, columns);
                }
                columns.add(columnName);
            }
        }
        return tablesToColumnConstraints;
    }

    @Override
    public void addConstraints(int version) throws CruDBException, IllegalStateException {
        this.disableUniqueConstraintsWithAutoIndexes();
        super.addConstraints(version);
        this.enableUniqueConstraintsWithAutoIndexes();
    }

    private void disableUniqueConstraintsWithAutoIndexes() throws CruDBException {
        this.enableUniqueConstraintsWithAutoIndexes(false);
    }

    private void enableUniqueConstraintsWithAutoIndexes() throws CruDBException {
        this.enableUniqueConstraintsWithAutoIndexes(true);
    }
}

