/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.crucible.spi.rpc.DatabaseChange;
import com.atlassian.fisheye.event.FisheyeEventPublisher;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.AuditListener;
import com.cenqua.crucible.hibernate.CompletedTransactionResettingHibernateSesionEventListener;
import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.CrowdAwareUserLoadListener;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.HibernateListenerInterceptor;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.hibernate.MaxRetriesReachedException;
import com.cenqua.crucible.hibernate.PostTransactionEventPublicationListener;
import com.cenqua.crucible.hibernate.PropertyLengthCheckerListener;
import com.cenqua.crucible.hibernate.ReviewItemIndexListener;
import com.cenqua.crucible.hibernate.SessionDecorator;
import com.cenqua.crucible.hibernate.SessionState;
import com.cenqua.crucible.hibernate.SessionTracker;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Function;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.log4j.NDC;
import org.hibernate.Cache;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.Statistics;

public class HibernateUtil {
    public static final int MAX_RETRIES = 10;
    public static final int DESIRED_RETRIABLE_POOL_SIZE = 3;
    private static final ThreadLocal<SessionState> threadSessionState = new ThreadLocal();
    private static final Object LOCK = new Object();
    private static final Object SINGLETON_SESSION_LOCK = new Object();
    private static SessionFactory sessionFactory;
    private static SessionFactory retriableSessionFactory;
    private static SessionFactory delegatingSessionFactory;
    private static Configuration cfg;
    private static final int STOPPED = 0;
    private static final int RUNNING = 1;
    private static final int READONLY = 2;
    private static volatile int dbstate;
    private static final Set<Session> sessions;
    private static SessionTracker debugTracker;
    private static final DuplicationStrategy USE_DERIVED;

    public static SessionFactory getSessionFactory() {
        return delegatingSessionFactory;
    }

    public static void turnSessionTrackingOn() {
        debugTracker = new SessionTracker();
    }

    public static void turnSessionTrackingOff() {
        debugTracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(DatabaseConfig dbConfig) throws CruDBException {
        Object object = LOCK;
        synchronized (object) {
            if (dbstate == 0) {
                try {
                    DatabaseConfig mainPoolConfig = new DatabaseConfig(dbConfig);
                    DatabaseConfig retriablePoolConfig = mainPoolConfig.stealConnections(3);
                    if (retriablePoolConfig.getMaxPoolSize() < 3) {
                        Logs.APP_LOG.warn((Object)"The Maximum Pool Connection setting is too small to dedicate sufficient connections to retriable pool, this may lead to poor performance.\nIncrease this parameter as described in https://confluence.atlassian.com/display/FISHEYE/Configuring+the+database+connection+pool");
                    }
                    if (Logs.APP_LOG.isDebugEnabled()) {
                        Logs.APP_LOG.debug((Object)String.format("Configuring db pools with (min/max connections): main(%1$d,%2$d), retriable(%3$d,%4$d).", mainPoolConfig.getMinPoolSize(), mainPoolConfig.getMaxPoolSize(), retriablePoolConfig.getMinPoolSize(), retriablePoolConfig.getMaxPoolSize()));
                    }
                    cfg = Config.getConfig(mainPoolConfig, "mainPool");
                    sessionFactory = cfg.buildSessionFactory();
                    HibernateUtil.registerEventListeners(sessionFactory);
                    retriableSessionFactory = Config.getConfig(retriablePoolConfig, 1, false, "retriablePool").buildSessionFactory();
                    dbstate = 1;
                }
                catch (Throwable ex) {
                    Logs.APP_LOG.error((Object)"Crucible Database setup failed.", ex);
                    throw new CruDBException(ex);
                }
            }
        }
    }

    private static void registerEventListeners(SessionFactory sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = ((SessionFactoryImplementor)sessionFactory).getServiceRegistry();
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        CrowdAwareUserLoadListener userLoadListener = new CrowdAwareUserLoadListener();
        EventListenerGroup postLoadListeners = eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD);
        postLoadListeners.addDuplicationStrategy(USE_DERIVED);
        postLoadListeners.appendListener((Object)userLoadListener);
        EventListenerGroup loadListeners = eventListenerRegistry.getEventListenerGroup(EventType.LOAD);
        loadListeners.addDuplicationStrategy(USE_DERIVED);
        loadListeners.appendListener((Object)userLoadListener);
    }

    public static Connection getActiveObjectsConnection() throws SQLException {
        Connection c2 = ((SessionFactoryImpl)sessionFactory).getConnectionProvider().getConnection();
        c2.setAutoCommit(true);
        return c2;
    }

    public static <T> List<T> typedList(Query q2) {
        return q2.list();
    }

    public static <T> List<T> typedList(Criteria c2) {
        return c2.list();
    }

    public static boolean isRunning() {
        return dbstate == 1 || dbstate == 2;
    }

    public static boolean isReadOnly() {
        return dbstate == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean anySessionsActive() {
        Object object = LOCK;
        synchronized (object) {
            return !sessions.isEmpty();
        }
    }

    public static boolean isCurrentSession() {
        return threadSessionState.get() != null;
    }

    public static Session currentSession() throws HibernateException {
        return new SessionDecorator(HibernateUtil.currentState().getSession()){

            @Override
            public Connection close() throws HibernateException {
                return HibernateUtil.internalCloseSession();
            }
        };
    }

    public static void markSessionReadOnly() {
        HibernateUtil.currentSession().setDefaultReadOnly(true);
        HibernateUtil.currentSession().setFlushMode(FlushMode.MANUAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionState currentState() throws HibernateException {
        SessionState sstate = threadSessionState.get();
        if (sstate == null || !sstate.getSession().isOpen()) {
            Object object = LOCK;
            synchronized (object) {
                if (!HibernateUtil.isRunning()) {
                    throw new HibernateException("Hibernate has been shutdown");
                }
                AuditListener auditListener = new AuditListener();
                HibernateListenerInterceptor interceptor = new HibernateListenerInterceptor(Arrays.asList(auditListener, new ReviewItemIndexListener(), new PropertyLengthCheckerListener(), new DatabaseChange.HibernateUpdateListener(), new PostTransactionEventPublicationListener()));
                Session s2 = sessionFactory.withOptions().eventListeners(new SessionEventListener[]{new CompletedTransactionResettingHibernateSesionEventListener(new HibernateUtilCurrentSessionProvider())}).interceptor((Interceptor)interceptor).openSession();
                auditListener.setSession(s2);
                sstate = new SessionState(s2);
                threadSessionState.set(sstate);
                sessions.add(s2);
                if (debugTracker != null) {
                    debugTracker.sessionOpened(s2);
                }
            }
        }
        return sstate;
    }

    public static int getSessionCount() {
        return sessions.size();
    }

    public static void clearSession() {
        SessionState state = threadSessionState.get();
        if (state != null) {
            state.getSession().clear();
        }
    }

    public static void closeSession() throws HibernateException {
        HibernateUtil.internalCloseSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection internalCloseSession() {
        SessionState state = threadSessionState.get();
        Connection connection = null;
        if (state != null) {
            Session s2 = state.getSession();
            connection = s2.close();
            Object object = LOCK;
            synchronized (object) {
                sessions.remove(s2);
                if (debugTracker != null) {
                    debugTracker.sessionClosed(s2);
                }
            }
        }
        threadSessionState.set(null);
        return connection;
    }

    public static void bounceTransaction() {
        HibernateUtil.commitAllTransactions();
        HibernateUtil.beginTransaction();
    }

    public static void logSessionStats(Session s2) {
        if (Logs.APP_LOG.isDebugEnabled()) {
            SessionStatistics stats = s2.getStatistics();
            Logs.APP_LOG.debug((Object)("Session: collections: " + stats.getCollectionCount() + ", Entities: " + stats.getEntityCount()));
        }
    }

    public static void beginTransaction() {
        int count = 0;
        while (dbstate == 2) {
            try {
                if (count == 0) {
                    Logs.APP_LOG.warn((Object)"Waiting for DB to become writeable.");
                    ++count;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                break;
            }
            Logs.APP_LOG.debug((Object)("Waited " + 100 * count + "ms"));
        }
        SessionState state = HibernateUtil.currentState();
        state.beginTx();
    }

    public static void commitTransaction() {
        SessionState state = threadSessionState.get();
        if (state == null) {
            return;
        }
        try {
            state.commitTx();
        }
        catch (RuntimeException e2) {
            HibernateUtil.closeSession();
            throw e2;
        }
    }

    @Nullable
    public static Throwable getTransactionBeginStacktrace() {
        SessionState state = threadSessionState.get();
        if (state == null) {
            return null;
        }
        return state.getTxBeginStacktrace();
    }

    public static void commitAllTransactions() {
        SessionState state = threadSessionState.get();
        if (state != null) {
            state.commitAllTx();
        }
    }

    public static void rollbackTransactionIfNotCommitted() {
        SessionState state = threadSessionState.get();
        if (state != null) {
            state.rollbackIfNotCommitedTx();
        }
    }

    public static void forceRollbackTransaction() {
        SessionState state = threadSessionState.get();
        if (state != null) {
            state.forceRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroy() {
        dbstate = 0;
        Logs.APP_LOG.info((Object)"Shutting down DB.");
        HibernateUtil.waitForSessions();
        HibernateUtil.closeSession();
        Object object = LOCK;
        synchronized (object) {
            if (sessionFactory != null) {
                sessionFactory.close();
                sessionFactory = null;
            }
            if (retriableSessionFactory != null) {
                retriableSessionFactory.close();
                retriableSessionFactory = null;
            }
            cfg = null;
        }
        return true;
    }

    public static void makeReadOnly() {
        if (!HibernateUtil.isRunning()) {
            throw new IllegalStateException("DB must be running to make readonly");
        }
        dbstate = 2;
        Logs.APP_LOG.info((Object)"DB going read only.");
        HibernateUtil.waitForSessions();
        HibernateUtil.closeSession();
    }

    public static void makeWritable() {
        if (!HibernateUtil.isRunning()) {
            throw new IllegalStateException("DB must be running to make writable");
        }
        dbstate = 1;
        Logs.APP_LOG.info((Object)"DB going writable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForSessions() {
        long closePauseTime = 500L;
        long closeAttemptTimeout = 20000L;
        long stopTryingAt = System.currentTimeMillis() + 20000L;
        while (HibernateUtil.anySessionsActive()) {
            if (System.currentTimeMillis() > stopTryingAt) {
                Logs.APP_LOG.error((Object)("Timed out waiting on " + sessions.size() + " sessions to close, forcing shutdown"));
                if (debugTracker == null) break;
                Object object = LOCK;
                synchronized (object) {
                    debugTracker.reportOpenSessions(sessions);
                    break;
                }
            }
            Logs.APP_LOG.info((Object)("Stopping DB, waiting for " + sessions.size() + " sessions to close."));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    public static void reportOpenSessions() {
        if (debugTracker != null) {
            debugTracker.reportOpenSessions(sessions);
        }
    }

    @Deprecated
    public static void ensureTransaction() {
        SessionState state = HibernateUtil.currentState();
        state.ensureTx();
    }

    public static boolean isCurrentTransaction() {
        SessionState state = threadSessionState.get();
        return state != null && state.getTx() != null;
    }

    public static Configuration getCfg() {
        return cfg;
    }

    public static <T> T withRetriableTransaction(WithSessionVisitor<T> closure) throws MaxRetriesReachedException {
        return HibernateUtil.withRetriableTransaction(closure, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withRetriableTransaction(WithSessionVisitor<T> closure, int maxRetries) throws MaxRetriesReachedException {
        int retried = 0;
        NDC.push((String)("withRetriableTransaction:" + closure.toString()));
        Throwable lastHibernateException = null;
        while (retried++ < maxRetries) {
            T t2;
            Session s2 = retriableSessionFactory.openSession();
            Transaction tx = s2.beginTransaction();
            try {
                T retval = closure.withSession(s2);
                tx.commit();
                t2 = retval;
            }
            catch (ConstraintViolationException cve) {
                Logs.APP_LOG.warn((Object)("Caught ConstraintViolationException while executing:" + closure + ". Going to retry " + (maxRetries - retried) + " more times"));
                lastHibernateException = cve;
                continue;
            }
            catch (LockAcquisitionException lae) {
                Logs.APP_LOG.warn((Object)("Caught LockAcquisitionException while executing:" + closure + ". Going to retry " + (maxRetries - retried) + " more times"));
                lastHibernateException = lae;
                continue;
            }
            catch (GenericJDBCException jdbce) {
                if (jdbce.getCause() == null || !(jdbce.getCause() instanceof BatchUpdateException)) {
                    throw jdbce;
                }
                Logs.APP_LOG.warn((Object)("Caught BatchUpdateException while executing:" + closure + ". Going to retry " + (maxRetries - retried) + " more times"));
                lastHibernateException = jdbce;
                continue;
            }
            finally {
                try {
                    if (tx.wasCommitted() || tx.wasRolledBack()) continue;
                    tx.rollback();
                    continue;
                }
                finally {
                    s2.close();
                    continue;
                }
            }
            return t2;
        }
        String msg = "Unable to execute " + closure + " after " + maxRetries + " retries. Giving up";
        Logs.APP_LOG.error((Object)msg, lastHibernateException);
        throw new MaxRetriesReachedException(msg);
        finally {
            NDC.pop();
        }
    }

    public static <T> T withReadOnlySession(WithSessionVisitor<T> closure) {
        s2.setDefaultReadOnly(true);
        try (Session s2 = sessionFactory.openSession();){
            T t2 = closure.withSession(s2);
            return t2;
        }
    }

    public static <T> void repairList(List<T> ts, ListAccessor<T> setter) {
        if (ts.contains(null)) {
            HibernateUtil.ensureTransaction();
            HibernateUtil.doRemoveNulls(ts, setter);
        }
        if (HibernateUtil.hasRepeatedIndices(ts, setter)) {
            HibernateUtil.ensureTransaction();
            ArrayList<T> backup = new ArrayList<T>(ts);
            try {
                HibernateUtil.doReorderRevisions(ts, setter);
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)"Deferring list repair");
                Collections.copy(ts, backup);
                HibernateUtil.setIndices(ts, setter);
            }
        }
    }

    protected static <T> void doReorderRevisions(List<T> ts, ListAccessor<T> setter) {
        Comparator<T> comparator;
        if (ts.size() > 0 && (comparator = setter.getComparator(ts.get(0))) != null) {
            Collections.sort(ts, setter.getComparator(ts.get(0)));
            HibernateUtil.setIndices(ts, setter);
        }
    }

    private static <T> void setIndices(List<T> ts, ListAccessor<T> setter) {
        for (int i2 = 0; i2 < ts.size(); ++i2) {
            setter.resetIndexOf(ts.get(i2), i2);
        }
    }

    protected static <T> boolean hasRepeatedIndices(List<T> ts, ListAccessor<T> setter) {
        IntOpenHashSet indexes = new IntOpenHashSet(ts.size());
        for (T t2 : ts) {
            if (indexes.add(setter.getIndexOf(t2))) continue;
            return true;
        }
        return false;
    }

    protected static <T> void doRemoveNulls(List<T> ts, ListAccessor<T> setter) {
        while (ts.contains(null)) {
            ts.remove(null);
        }
        for (int i2 = 0; i2 < ts.size(); ++i2) {
            setter.resetIndexOf(ts.get(i2), i2);
        }
    }

    public static DBType getTypeForSession(Session session) {
        if (session.getSessionFactory() instanceof SessionFactoryImplementor) {
            Dialect dialect = ((SessionFactoryImplementor)session.getSessionFactory()).getDialect();
            for (DBType dbType : DBType.values()) {
                if (!dialect.getClass().getName().equals(dbType.getDialect())) continue;
                return dbType;
            }
        }
        return null;
    }

    public static boolean enqueueEvent(FisheyeEventPublisher.EventPublication event) {
        SessionState sessionState;
        Transaction currentTx;
        if (HibernateUtil.isCurrentSession() && (currentTx = (sessionState = HibernateUtil.currentState()).getTx()) != null && currentTx.isActive()) {
            sessionState.enqueueEvent(event);
            return true;
        }
        return false;
    }

    public static Iterable<FisheyeEventPublisher.EventPublication> drainSessionEventQueue() {
        if (HibernateUtil.isCurrentSession()) {
            return HibernateUtil.currentState().drainQueuedEvents();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> T withIterator(Query query, Function<Iterator<V>, T> function) {
        Iterator iterator = query.iterate();
        try {
            Object object = function.apply((Object)iterator);
            return (T)object;
        }
        finally {
            Hibernate.close((Iterator)iterator);
        }
    }

    static {
        delegatingSessionFactory = new DelegatingSessionFactory();
        dbstate = 0;
        sessions = new HashSet<Session>();
        debugTracker = CrucibleSysProps.TRACK_SESSIONS ? new SessionTracker() : null;
        USE_DERIVED = new DuplicationStrategy(){

            public boolean areMatch(Object added, Object existing) {
                Class<?> existingClass = existing.getClass();
                Class<?> addedClass = added.getClass();
                return !addedClass.equals(existingClass) && existingClass.isInstance(added);
            }

            public DuplicationStrategy.Action getAction() {
                return DuplicationStrategy.Action.REPLACE_ORIGINAL;
            }
        };
    }

    private static class DelegatingSessionFactory
    implements SessionFactory {
        private DelegatingSessionFactory() {
        }

        public Reference getReference() throws NamingException {
            return sessionFactory.getReference();
        }

        public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
            return sessionFactory.getSessionFactoryOptions();
        }

        public SessionBuilder withOptions() {
            return sessionFactory.withOptions();
        }

        public Session openSession() throws HibernateException {
            return sessionFactory.openSession();
        }

        public Session getCurrentSession() throws HibernateException {
            return HibernateUtil.currentSession();
        }

        public StatelessSessionBuilder withStatelessOptions() {
            return sessionFactory.withStatelessOptions();
        }

        public StatelessSession openStatelessSession() {
            return sessionFactory.openStatelessSession();
        }

        public StatelessSession openStatelessSession(Connection connection) {
            return sessionFactory.openStatelessSession(connection);
        }

        public ClassMetadata getClassMetadata(Class entityClass) {
            return sessionFactory.getClassMetadata(entityClass);
        }

        public ClassMetadata getClassMetadata(String entityName) {
            return sessionFactory.getClassMetadata(entityName);
        }

        public CollectionMetadata getCollectionMetadata(String roleName) {
            return sessionFactory.getCollectionMetadata(roleName);
        }

        public Map getAllClassMetadata() {
            return sessionFactory.getAllClassMetadata();
        }

        public Map getAllCollectionMetadata() {
            return sessionFactory.getAllCollectionMetadata();
        }

        public Statistics getStatistics() {
            return sessionFactory.getStatistics();
        }

        public void close() throws HibernateException {
            sessionFactory.close();
        }

        public boolean isClosed() {
            return sessionFactory.isClosed();
        }

        public Cache getCache() {
            return sessionFactory.getCache();
        }

        public void evict(Class persistentClass) throws HibernateException {
            sessionFactory.evict(persistentClass);
        }

        public void evict(Class persistentClass, Serializable id) throws HibernateException {
            sessionFactory.evict(persistentClass, id);
        }

        public void evictEntity(String entityName) throws HibernateException {
            sessionFactory.evictEntity(entityName);
        }

        public void evictEntity(String entityName, Serializable id) throws HibernateException {
            sessionFactory.evictEntity(entityName, id);
        }

        public void evictCollection(String roleName) throws HibernateException {
            sessionFactory.evictCollection(roleName);
        }

        public void evictCollection(String roleName, Serializable id) throws HibernateException {
            sessionFactory.evictCollection(roleName, id);
        }

        public void evictQueries(String cacheRegion) throws HibernateException {
            sessionFactory.evictQueries(cacheRegion);
        }

        public void evictQueries() throws HibernateException {
            sessionFactory.evictQueries();
        }

        public Set getDefinedFilterNames() {
            return sessionFactory.getDefinedFilterNames();
        }

        public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
            return sessionFactory.getFilterDefinition(filterName);
        }

        public boolean containsFetchProfileDefinition(String name) {
            return sessionFactory.containsFetchProfileDefinition(name);
        }

        public TypeHelper getTypeHelper() {
            return sessionFactory.getTypeHelper();
        }
    }

    public static interface ListAccessor<T> {
        public void resetIndexOf(T var1, int var2);

        public int getIndexOf(T var1);

        public Comparator<? super T> getComparator(@Nonnull T var1);
    }

    public static interface WithSessionVisitor<T> {
        public T withSession(Session var1);
    }
}

