/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.OracleDialectUtils;
import org.hibernate.Session;

public class DialectUtils {
    protected DialectUtils() {
    }

    public String getClobsEqualExpression(String colName, String expression) {
        if (colName == null) {
            throw new NullPointerException("Column name must not be null");
        }
        if ("null".equalsIgnoreCase(String.valueOf(expression).trim())) {
            return String.format("%s is null", colName);
        }
        return String.format("%s = %s", colName, expression);
    }

    public static DialectUtils getFor(Session session) {
        if (HibernateUtil.getTypeForSession(session) == DBType.ORACLE) {
            return new OracleDialectUtils();
        }
        return new DialectUtils();
    }
}

