/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DbVersionManager;
import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultDbVersionManager
implements DbVersionManager {
    private final DBControlFactory dbControlFactory;

    @Autowired
    public DefaultDbVersionManager(DBControlFactory dbControlFactory) {
        this.dbControlFactory = dbControlFactory;
    }

    @Override
    public void setDbVersionValue(final int key, final int value) throws SQLException {
        this.dbControlFactory.getCurrentControl().withConnection(new DBControl.JdbcOp<Void>(){

            @Override
            public Void withConnection(Connection c2) throws SQLException {
                c2.setAutoCommit(false);
                int rows = DefaultDbVersionManager.this.updateVersion(c2, value, key);
                if (rows == 0 && (rows = DefaultDbVersionManager.this.insertVersion(c2, key, value)) != 1) {
                    throw new SQLException("Failed to insert new row into cru_version with key value '" + key + "'");
                }
                c2.commit();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateVersion(Connection c2, int value, int key) throws SQLException {
        PreparedStatement s2 = null;
        try {
            s2 = c2.prepareStatement("update cru_version set cru_version = ? where cru_version_id = ?");
            s2.setInt(1, value);
            s2.setInt(2, key);
            int n2 = s2.executeUpdate();
            return n2;
        }
        finally {
            JDBCHelper.closeQuietly(s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertVersion(Connection c2, int key, int value) throws SQLException {
        PreparedStatement s2 = null;
        try {
            s2 = c2.prepareStatement("insert into cru_version values (?,?)");
            s2.setInt(1, key);
            s2.setInt(2, value);
            int n2 = s2.executeUpdate();
            return n2;
        }
        finally {
            JDBCHelper.closeQuietly(s2);
        }
    }

    @Override
    public Integer getDbVersionValue(final int key) throws SQLException {
        return this.dbControlFactory.getCurrentControl().withConnection(new DBControl.JdbcOp<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer withConnection(Connection c2) throws SQLException {
                ResultSet rs;
                Statement s2;
                block3: {
                    Integer n2;
                    s2 = null;
                    rs = null;
                    try {
                        s2 = c2.createStatement();
                        rs = s2.executeQuery("select cru_version from cru_version where cru_version_id = " + key);
                        if (!rs.next()) break block3;
                        n2 = rs.getInt("cru_version");
                    }
                    catch (Throwable throwable) {
                        JDBCHelper.closeQuietly(rs, s2);
                        throw throwable;
                    }
                    JDBCHelper.closeQuietly(rs, s2);
                    return n2;
                }
                Integer n3 = null;
                JDBCHelper.closeQuietly(rs, s2);
                return n3;
            }
        });
    }

    @Override
    public int getDbTimeStamp() throws SQLException {
        Integer dbTimeStamp = this.getDbVersionValue(2);
        if (dbTimeStamp == null) {
            dbTimeStamp = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
            this.setDbVersionValue(2, dbTimeStamp);
        }
        return dbTimeStamp;
    }
}

