/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlConnectionProvider;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DatabaseConfigDBControlConnectionProvider;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.crucible.hibernate.DefaultDBInfo;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.OracleDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTaskManager;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class DefaultDBControl
implements DBControl {
    protected volatile DBInfo.DBState currentState;
    protected volatile DBType currentDBType;
    protected volatile Integer version = null;
    protected final DatabaseConfig dbConfig;
    protected final DBControlConnectionProvider connectionProvider;
    protected File sqlDir;
    protected String message = "";
    protected Throwable startersStacktrace;
    protected DBControlFactory dbControlFactory;

    public static DefaultDBControl newInstance(DatabaseConfig dbConfig, File sqlDir) {
        return DefaultDBControl.newInstance(dbConfig, new DatabaseConfigDBControlConnectionProvider(dbConfig), sqlDir);
    }

    public static DefaultDBControl newInstance(DatabaseConfig dbConfig, DBControlConnectionProvider connectionProvider, File sqlDir) {
        if (dbConfig.getType() == DBType.ORACLE) {
            return new OracleDBControl(dbConfig, connectionProvider, sqlDir);
        }
        return new DefaultDBControl(dbConfig, connectionProvider, sqlDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultDBControl(DatabaseConfig dbConfig, DBControlConnectionProvider connectionProvider, File sqlDir) {
        this.dbConfig = dbConfig;
        this.sqlDir = sqlDir;
        this.connectionProvider = connectionProvider;
        this.currentDBType = dbConfig.getType();
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            this.version = this.checkVersion(conn);
        }
        catch (Exception e2) {
            this.currentState = DBInfo.DBState.NO_DB;
            this.message = String.format("Unable to connect to %s database %s: %s: %s", this.currentDBType.getDisplayName(), dbConfig.getJdbcURL(), e2.getClass().getName(), e2.getMessage());
            if (e2 instanceof ClassNotFoundException) {
                if (this.currentDBType.equals((Object)DBType.MYSQL) && dbConfig.getDriverSource().equals(DriverSource.BUNDLED.toString())) {
                    this.updateMySQLConfigAndShutdown();
                } else {
                    this.message = this.message + ": is the database driver jar file properly installed in the FISHEYE_INST/lib directory?";
                }
            }
            Logs.APP_LOG.error((Object)this.message, (Throwable)e2);
            Logs.APP_LOG.debug((Object)"Exception connecting to DB", (Throwable)e2);
            return;
        }
        finally {
            this.closeConnection(conn);
        }
        this.currentState = this.version == null ? DBInfo.DBState.NO_TABLES : DBInfo.DBState.STOPPED;
    }

    private void updateMySQLConfigAndShutdown() {
        try {
            RootConfig rootConfig = AppConfig.getsConfig();
            File configFile = rootConfig.getConfigFile();
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"************************************************************************************************************************");
            Logs.APP_LOG.info((Object)"     Due to license restrictions the MySQL JDBC driver can not be bundled with FishEye/Crucible.");
            Logs.APP_LOG.info((Object)"     Please download the driver from   http://dev.mysql.com/downloads/connector/j/ ");
            Logs.APP_LOG.info((Object)("     and install it to the FISHEYE_INST/lib directory: " + AppConfig.getInstanceDir() + File.separatorChar + "lib."));
            Logs.APP_LOG.info((Object)"     See this page for more information: https://confluence.atlassian.com/display/FISHEYE/Migrating+to+MySQL+Enterprise+Server");
            Logs.APP_LOG.info((Object)"");
            if (configFile != null && configFile.isFile()) {
                rootConfig.getConfig().getDatabase().getConnection().setDriverSource(DriverSource.USER);
                rootConfig.saveConfig();
                Logs.APP_LOG.info((Object)"     The database settings in config.xml have been upgraded. Please restart FishEye/Crucible.");
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"     Error while updating your configuration. Your database settings were not changed.");
            Logs.APP_LOG.info((Object)"     Please edit your config.xml file directly (make a backup before editing):");
            Logs.APP_LOG.info((Object)"     set driverSource=\"user\" for the <connection> element.");
            Logs.APP_LOG.error((Object)"     Error was:", (Throwable)e2);
        }
        finally {
            Logs.APP_LOG.info((Object)"************************************************************************************************************************");
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"");
            System.exit(1);
        }
    }

    @Override
    public void setDbControlFactory(DBControlFactory dbControlFactory) {
        this.dbControlFactory = dbControlFactory;
    }

    @Override
    public String getErrorMessage() {
        return this.message;
    }

    @Override
    public <T> T withConnection(DBControl.JdbcOp<T> op) throws SQLException {
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            T t2 = op.withConnection(conn);
            return t2;
        }
        catch (ClassNotFoundException e2) {
            Logs.APP_LOG.error((Object)"Error getting connection", (Throwable)e2);
            SQLException sqlE = new SQLException("Error getting connection");
            sqlE.initCause(e2);
            throw sqlE;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    @Override
    public DBInfo getInfo() {
        return new DefaultDBInfo(this.dbConfig, this.currentState, this.currentDBType, this.version, this.startersStacktrace);
    }

    @Override
    public DatabaseConfig getConfig() {
        return this.dbConfig;
    }

    @Override
    public boolean isEmpty() {
        return DBInfo.DBState.NO_TABLES.equals((Object)this.currentState);
    }

    @Override
    public boolean isRunning() {
        return DBInfo.DBState.STARTED.equals((Object)this.currentState);
    }

    @Override
    public boolean isStopped() {
        return DBInfo.DBState.STOPPED.equals((Object)this.currentState);
    }

    @Override
    public void readOnly(boolean readOnly) throws IllegalStateException {
        if (readOnly) {
            this.makeReadOnly();
        } else {
            this.makeWritable();
        }
    }

    private void makeReadOnly() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.STARTED.name(), this.currentState.name()));
        }
        this.currentState = DBInfo.DBState.READ_ONLY;
        HibernateUtil.makeReadOnly();
    }

    private void makeWritable() throws IllegalStateException {
        if (!DBInfo.DBState.READ_ONLY.equals((Object)this.currentState)) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.READ_ONLY.name(), this.currentState.name()));
        }
        this.currentState = DBInfo.DBState.STARTED;
        HibernateUtil.makeWritable();
    }

    @Override
    public void stop() throws CruDBException {
        Logs.setConsoleLevel((Priority)Level.INFO);
        Logs.APP_LOG.info((Object)"Shutdown in progress...");
        if (this.isRunning()) {
            if (this.dbControlFactory != null) {
                this.dbControlFactory.changeState(false);
            }
            this.currentState = DBInfo.DBState.STOPPED;
            HibernateUtil.closeSession();
            HibernateUtil.destroy();
        }
        this.connectionProvider.shutdown();
    }

    @Override
    public void start() throws CruDBException, IllegalStateException {
        this.start(DbVersion.getDatabaseVersion());
    }

    @Override
    public void start(int version) throws CruDBException, IllegalStateException {
        Logs.APP_LOG.info((Object)"Starting database...");
        this.validateConnectionAndExitOnFailure();
        if (this.isEmpty()) {
            this.createTables(version);
            this.addConstraints(version);
            this.addInitData(version);
        }
        if (this.isStopped()) {
            if (this.version < version) {
                this.upgrade(version);
            } else if (this.version > version) {
                throw new IllegalStateException(this.makeVersionErrorMessage("starting", version));
            }
            HibernateUtil.setUp(this.dbConfig);
            this.currentState = DBInfo.DBState.STARTED;
            Logs.APP_LOG.info((Object)"Database started.");
            this.startersStacktrace = new Throwable("started at " + new Date());
            if (this.dbControlFactory != null) {
                this.dbControlFactory.changeState(true);
            }
        } else {
            if (DBInfo.DBState.NO_DB.equals((Object)this.currentState)) {
                throw new IllegalStateException(String.format("Database not available (%s). Current state: %s", this.message, this.currentState.name()));
            }
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.STOPPED.name(), this.currentState.name()));
        }
    }

    private String makeVersionErrorMessage(String operation, int expectedVersion) {
        return String.format("Problem %s the database : The current database schema version is %s, but it should be %s or below. Downgrading of the database is not supported. Please visit %s for information on restoring from a backup", operation, this.version, expectedVersion, HelpUtil.getFishEyeHelpPath("fisheye.backup.restore.config"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dropTables() throws CruDBException, IllegalStateException {
        if (!this.isStopped()) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.STOPPED.name(), this.currentState.name()));
        }
        if (this.isDowngrading()) {
            throw new IllegalStateException(this.makeVersionErrorMessage("stopping", DbVersion.getDatabaseVersion()));
        }
        this.currentState = DBInfo.DBState.NO_TABLES;
        BufferedReader in = null;
        File dropFile = null;
        if (this.version == null) return;
        try {
            dropFile = this.makeDBScriptFile(DBScriptType.drop, this.version);
            in = new BufferedReader(new FileReader(dropFile));
            this.executeScript(in);
        }
        catch (IOException e2) {
            try {
                throw new CruDBException("Problem opening drop script", e2);
                catch (CruDBException e3) {
                    throw new CruDBException(String.format("Problem running drop script (you may have to manually drop the DB) %s", dropFile.getPath()), e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
        }
        IOHelper.close(in);
        this.connectionProvider.shutdown();
    }

    private boolean isDowngrading() {
        return this.version > DbVersion.getDatabaseVersion();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createTables(int version) throws CruDBException, IllegalStateException {
        if (!this.isEmpty()) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.NO_TABLES.name(), this.currentState.name()));
        }
        BufferedReader in = null;
        File file = null;
        try {
            file = this.makeDBScriptFile(DBScriptType.tables, version);
            Logs.APP_LOG.info((Object)String.format("Creating DB schema version %d using %s", version, file));
            in = new BufferedReader(new FileReader(file));
            this.executeScript(in);
            this.updateVersion();
            this.currentState = DBInfo.DBState.NO_CONSTRAINTS;
        }
        catch (IOException e2) {
            try {
                throw new CruDBException("Problem opening create tables script", e2);
                catch (CruDBException e3) {
                    throw new CruDBException(String.format("Problem with create tables script %s", file.getPath()), e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
        }
        IOHelper.close(in);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addConstraints(int version) throws CruDBException, IllegalStateException {
        if (!DBInfo.DBState.NO_CONSTRAINTS.equals((Object)this.currentState)) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.NO_CONSTRAINTS.name(), this.currentState.name()));
        }
        BufferedReader in = null;
        File file = null;
        try {
            file = this.makeDBScriptFile(DBScriptType.constraints, version);
            Logs.APP_LOG.info((Object)String.format("Creating DB constraints version %d using %s", version, file));
            in = new BufferedReader(new FileReader(file));
            this.executeScript(in);
            this.connectionProvider.shutdown();
            this.currentState = DBInfo.DBState.STOPPED;
        }
        catch (IOException e2) {
            try {
                throw new CruDBException("Problem opening constraints script", e2);
                catch (CruDBException e3) {
                    throw new CruDBException(String.format("Problem with constraints script %s", file.getPath()), e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
        }
        IOHelper.close(in);
    }

    public File makeDBScriptFile(DBScriptType type, int version) {
        return new File(this.sqlDir, this.currentDBType.getDdlDirectory() + type.getParentDirAndFilePrefix() + version + ".sql");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addInitData(int version) throws CruDBException, IllegalStateException {
        if (!this.isStopped()) {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.NO_TABLES.name(), this.currentState.name()));
        }
        BufferedReader in = null;
        File file = null;
        try {
            file = this.makeDBScriptFile(DBScriptType.data, version);
            if (file.exists()) {
                Logs.APP_LOG.info((Object)String.format("Loading initial DB data version %d using %s", version, file));
                in = new BufferedReader(new FileReader(file));
                this.executeScript(in);
            } else {
                Logs.APP_LOG.warn((Object)("No data file for db version " + version + " - " + file.getAbsolutePath()));
            }
        }
        catch (IOException e2) {
            try {
                throw new CruDBException("Problem opening data script", e2);
                catch (CruDBException e3) {
                    throw new CruDBException("Problem with data script " + file.getPath(), e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
        }
        IOHelper.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(int reqVersion) throws CruDBException, IllegalStateException {
        if (this.isStopped()) {
            File file = null;
            try {
                while (this.version < reqVersion) {
                    file = this.makeDBScriptFile(DBScriptType.upgrade, this.version);
                    Logs.APP_LOG.info((Object)String.format("Upgrading DB from version %d using %s", this.version, file));
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new FileReader(file));
                        this.doUpgrade(in);
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(in);
                        throw throwable;
                    }
                    IOHelper.close(in);
                }
                this.connectionProvider.shutdown();
            }
            catch (Exception e2) {
                if (file != null) {
                    throw new CruDBException(String.format("Problem upgrading with script %s: %s", file.getPath(), e2.getMessage()), e2);
                }
                throw new CruDBException("Problem upgrading database", e2);
            }
        } else {
            throw new IllegalStateException(String.format("Database must be in %s state, currently %s", DBInfo.DBState.STOPPED.name(), this.currentState.name()));
        }
    }

    protected Connection getMaintenanceConnection() throws CruDBException {
        if (DBInfo.DBState.NO_DB.equals((Object)this.currentState)) {
            throw new IllegalStateException(String.format("Database not available (%s). Current state: %s", this.message, this.currentState.name()));
        }
        try {
            return this.connectionProvider.getMaintenanceConnection();
        }
        catch (Exception e2) {
            throw new CruDBException(e2);
        }
    }

    private void doUpgrade(BufferedReader in) throws CruDBException, SQLException {
        UpgradeTask ut = UpgradeTaskManager.findUpgradeTasks(this.version);
        Connection conn = this.getMaintenanceConnection();
        this.validateConnectionAndExitOnFailure(conn);
        try {
            ut.beforeUpgradeScript(conn, this.getType());
            this.executeScript(in);
            IOHelper.close(in);
            ut.afterUpgradeScript(conn, this.getType());
            this.updateVersion();
        }
        catch (CruDBException e2) {
            ut.upgradeFailed(conn, this.getType());
            throw e2;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void validateConnectionAndExitOnFailure() throws CruDBException {
        Connection connection = this.getConnection();
        try {
            this.validateConnectionAndExitOnFailure(connection);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void validateConnectionAndExitOnFailure(Connection connection) {
        boolean isValid = false;
        try {
            isValid = this.currentDBType.isUTF8AndCaseSensitive(connection);
        }
        catch (SQLException e2) {
            Logs.APP_LOG.error((Object)String.format("Error when validating DB connection: %s. Assuming DB not valid.", e2.getMessage()), (Throwable)e2);
        }
        if (!isValid) {
            Logs.APP_LOG.fatal((Object)"FeCru connecting to DB not using case-sensitive UTF8 encoding");
            Logs.APP_LOG.fatal((Object)"Shutting down FeCru...");
            System.exit(1);
        }
    }

    public void executeCommand(String line) throws CruDBException {
        this.executeScript(new BufferedReader(new StringReader(line)));
    }

    @Override
    public void executeScript(BufferedReader in) throws CruDBException {
        Connection conn = this.getMaintenanceConnection();
        try {
            this.executeScript(in, conn);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(BufferedReader in, Connection conn) throws CruDBException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        int lineNo = 0;
        String sqlCommand = "";
        try {
            boolean autoCommitSave = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Statement s2 = conn.createStatement();
            LinkedList<String> procLines = null;
            try {
                String line;
                while ((line = in.readLine()) != null && !line.equals("!stop")) {
                    ++lineNo;
                    if (DefaultDBControl.blankOrComment(line)) continue;
                    if (line.equals("!proc")) {
                        procLines = new LinkedList<String>();
                        continue;
                    }
                    if (procLines != null) {
                        if (!line.equals("!endproc")) {
                            procLines.add(line);
                            continue;
                        }
                        s2.executeUpdate(StringUtils.join(procLines, (String)"\n"));
                        procLines = null;
                        continue;
                    }
                    if ((sqlCommand = sqlCommand + line.replaceAll("\\\\n", "\n")).endsWith(";")) {
                        if (sqlCommand.trim().startsWith("$")) {
                            this.handleVariable(vars, sqlCommand, s2);
                            sqlCommand = "";
                            continue;
                        }
                        for (Map.Entry es : vars.entrySet()) {
                            sqlCommand = sqlCommand.replaceAll("\\$" + (String)es.getKey(), es.getValue() == null ? "null" : es.getValue().toString());
                        }
                        Logs.APP_LOG.debug((Object)("Update executing: " + sqlCommand));
                        s2.executeUpdate(this.processCommand(sqlCommand));
                        sqlCommand = "";
                        continue;
                    }
                    sqlCommand = sqlCommand + " ";
                }
                String trimmedSqlCommand = sqlCommand.trim();
                if (trimmedSqlCommand.length() > 0) {
                    if (!trimmedSqlCommand.endsWith(";")) {
                        trimmedSqlCommand = trimmedSqlCommand + ';';
                    }
                    s2.executeUpdate(this.processCommand(trimmedSqlCommand));
                }
                conn.commit();
            }
            finally {
                s2.close();
                conn.rollback();
                conn.setAutoCommit(autoCommitSave);
            }
        }
        catch (IOException e2) {
            throw new CruDBException(String.format("SQL script error on line %d: \"%s\" \n(%s), please contact http://www.atlassian.com/support/", lineNo, sqlCommand, e2.getMessage()), e2);
        }
        catch (SQLException e3) {
            throw new CruDBException(String.format("SQL script error on line %d: \"%s\" \n(%s), please contact http://www.atlassian.com/support/", lineNo, sqlCommand, e3.getMessage()), e3);
        }
    }

    protected String processCommand(String sqlCommand) {
        return sqlCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVariable(HashMap<String, Object> vars, String sqlCommand, Statement s2) throws SQLException {
        String[] var = sqlCommand.split("=");
        try (ResultSet r2 = null;){
            r2 = s2.executeQuery(var[1].trim());
            if (r2.next()) {
                vars.put(var[0].substring(1).trim(), r2.getObject(1));
            }
        }
    }

    private static boolean blankOrComment(String str) {
        return str.trim().equals("") || str.startsWith("#") || str.startsWith("-- ");
    }

    @Override
    public Connection getConnection() throws CruDBException, IllegalStateException {
        if (DBInfo.DBState.NO_DB.equals((Object)this.currentState)) {
            throw new IllegalStateException(String.format("Database not available (%s). Current state: %s", this.message, this.currentState.name()));
        }
        try {
            return this.connectionProvider.getConnection();
        }
        catch (Exception e2) {
            throw new CruDBException(e2);
        }
    }

    @Override
    public void closeConnection(Connection conn) {
        try {
            if (conn == null || conn.isClosed()) {
                return;
            }
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
            conn.close();
        }
        catch (SQLException e2) {
            Logs.APP_LOG.error((Object)"Error closing DB connection", (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer checkVersion(Connection conn) throws CruDBException, SQLException {
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet tables = conn.getMetaData().getTables(null, null, "%", tableTypes);
        Statement statement = conn.createStatement();
        try {
            if (statement.getResultSetType() != 1003) {
                tables.beforeFirst();
            }
            while (tables.next()) {
                String table = tables.getString("TABLE_NAME");
                if ("CRUVERSION".equalsIgnoreCase(table)) {
                    Integer n2 = this.pre31version(statement);
                    return n2;
                }
                if (!"CRU_VERSION".equalsIgnoreCase(table)) continue;
                Integer n3 = this.post31version(statement);
                return n3;
            }
            Integer n4 = null;
            return n4;
        }
        finally {
            statement.close();
            tables.close();
        }
    }

    private Integer pre31version(Statement statement) throws CruDBException, SQLException {
        Integer cruVersion = (Integer)this.querySingleValue(statement, "SELECT version FROM cruversion WHERE version_id = 1", "version");
        if (cruVersion == null) {
            throw new CruDBException("Unknown DB Version: Version table exists but the version is not set.");
        }
        return cruVersion;
    }

    private Integer post31version(Statement statement) throws CruDBException, SQLException {
        Number cruVersion = (Number)this.querySingleValue(statement, "SELECT cru_version FROM cru_version WHERE cru_version_id = 1", "cru_version");
        if (cruVersion == null) {
            throw new CruDBException("Unknown DB Version: Version table exists but the version is not set.");
        }
        return cruVersion.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object querySingleValue(Statement statement, String query, String colName) throws SQLException {
        try (ResultSet rs = statement.executeQuery(this.processCommand(query));){
            if (rs.next()) {
                Object object = rs.getObject(colName);
                return object;
            }
        }
        return null;
    }

    private void updateVersion() throws CruDBException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.version = this.checkVersion(conn);
        }
        catch (Exception e2) {
            this.currentState = DBInfo.DBState.NO_DB;
            this.message = e2.getClass().getName() + ": " + e2.getMessage();
            Logs.APP_LOG.error((Object)("Error updating database: " + this.message), (Throwable)e2);
            throw new CruDBException("Problem checking version", e2);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    @Override
    public DBType getType() {
        return this.dbConfig.getType();
    }

    public static enum DBScriptType {
        drop,
        tables,
        constraints,
        data,
        upgrade("upgrade");

        private final String parent;

        private DBScriptType() {
            this("schema");
        }

        private DBScriptType(String parent) {
            this.parent = parent;
        }

        public String getParentDirAndFilePrefix() {
            return "/" + this.parent + "/" + this.name() + "_";
        }
    }
}

