/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.filters.SimpleMessage;
import com.cenqua.fisheye.web.filters.SystemMessage;
import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DbFooterMessageSource
implements MessageSource {
    private final DBControlFactory dbControlFactory;
    private Boolean isDbTxIsolationOptimal = null;

    @Autowired
    public DbFooterMessageSource(DBControlFactory dbControlFactory) {
        this.dbControlFactory = dbControlFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SystemMessage> getMessages(HttpServletRequest request) {
        LinkedList<SystemMessage> messages = new LinkedList<SystemMessage>();
        LazyConnection lc = new LazyConnection();
        try {
            messages.addAll(this.getTxIsolationMessages(lc));
            messages.addAll(this.getHSQLMessages());
        }
        finally {
            lc.closeQuietly();
        }
        return Collections.unmodifiableList(messages);
    }

    private List<SystemMessage> getTxIsolationMessages(LazyConnection lc) {
        if (this.dbControlFactory.getCurrentControl().getInfo().state().equals((Object)DBInfo.DBState.STARTED)) {
            if (this.isDbTxIsolationOptimal == null) {
                try {
                    this.isDbTxIsolationOptimal = this.dbControlFactory.getCurrentControl().getInfo().type().isTxIsolationOptimal(lc.getConnection());
                }
                catch (Exception e2) {
                    Logs.APP_LOG.error((Object)"Error checking DB tx isolation settings", (Throwable)e2);
                }
            }
            if (this.isDbTxIsolationOptimal != null && !this.isDbTxIsolationOptimal.booleanValue()) {
                return Collections.singletonList(new SimpleMessage("Your database current transaction isolation level may lead to performance problems. Enable READ_COMMITTED_SNAPSHOT level.", HelpUtil.getFishEyeHelpPath("fisheye.sql.server.migration"), true, SimpleMessage.ShowIn.FOOTER));
            }
        }
        return Collections.emptyList();
    }

    private List<SystemMessage> getHSQLMessages() {
        if (this.dbControlFactory.getCurrentControl().getInfo().type() == DBType.HSQL) {
            String productName = AppConfig.getProductName();
            String message = this.isEvaluation() ? String.format("This %s instance is using HSQLDB, which is only supported in evaluation environments", productName) : String.format("This %s instance is using HSQLDB, which is not supported in production environments.", productName);
            return Collections.singletonList(new SimpleMessage(message, HelpUtil.getFishEyeHelpPath("fisheye.supported.platforms"), true, SimpleMessage.ShowIn.FOOTER));
        }
        return Collections.emptyList();
    }

    private boolean isEvaluation() {
        LicenseInfo licenseInfo = AppConfig.getsConfig().getLicense();
        return licenseInfo != null && licenseInfo.isAllProductsInEval();
    }

    public void resetTest() {
        this.isDbTxIsolationOptimal = null;
    }

    class LazyConnection {
        private Connection connection;

        LazyConnection() {
        }

        Connection getConnection() throws CruDBException {
            if (null == this.connection) {
                this.connection = DbFooterMessageSource.this.dbControlFactory.getCurrentControl().getConnection();
            }
            return this.connection;
        }

        void closeQuietly() {
            JDBCHelper.closeQuietly(this.connection);
            this.connection = null;
        }
    }
}

