/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBControlConnectionProvider;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseConfigDBControlConnectionProvider
implements DBControlConnectionProvider {
    private final DatabaseConfig dbConfig;

    public DatabaseConfigDBControlConnectionProvider(DatabaseConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    @Override
    public Connection getConnection() throws SQLException, ClassNotFoundException {
        return this.connect(JdbcUrlMangler.NO_CHANGE);
    }

    @Override
    public Connection getMaintenanceConnection() throws SQLException, ClassNotFoundException {
        return this.connect(JdbcUrlMangler.STRIP_SOCKET_TIMEOUT);
    }

    private Connection connect(JdbcUrlMangler jdbcUrlMangler) throws ClassNotFoundException, SQLException {
        Class.forName(this.dbConfig.getJdbcDriverClass());
        return DriverManager.getConnection(jdbcUrlMangler.apply(this.dbConfig.getJdbcURL()), this.dbConfig.getUsername(), this.dbConfig.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.dbConfig.getType().equals((Object)DBType.HSQL)) {
            try (Connection conn = this.getConnection();
                 Statement st = null;){
                st = conn.createStatement();
                st.execute("SHUTDOWN");
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)("Unexpected problem shutting down HSQLDB" + e2.getMessage()));
            }
        }
    }

    public static enum JdbcUrlMangler {
        NO_CHANGE{

            @Override
            public String apply(String jdbcUrl) {
                return jdbcUrl;
            }
        }
        ,
        STRIP_SOCKET_TIMEOUT{

            @Override
            public String apply(String jdbcUrl) {
                Preconditions.checkNotNull((Object)jdbcUrl);
                String ret = jdbcUrl.replaceAll("socketTimeout\\s*=\\s*[0-9]*[1-9][0-9]*\\s*&?", "");
                if (ret.endsWith("&") || ret.endsWith("?") && ret.indexOf(63) == ret.length() - 1) {
                    ret = ret.substring(0, ret.length() - 1);
                }
                if (!ret.equals(jdbcUrl)) {
                    Logs.APP_LOG.warn((Object)("Stripped socketTimeout parameter from JDBC URL to perform upgrade. Old URL: " + jdbcUrl + ", new: " + ret));
                }
                return ret;
            }
        };


        public abstract String apply(String var1);
    }
}

