/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.util.PropertiesUtil;
import java.util.Properties;

public class DatabaseConfig {
    public static final String JDBCURL = "jdbcUrl";
    public static final String DIALECT = "jdbcDialect";
    public static final String DRIVER = "jdbcDriverClass";
    public static final String USERNAME = "jdbcUsername";
    public static final String PASSWORD = "jdbcPassword";
    public static final int DEFAULT_MIN_POOL_SIZE = 5;
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    private DBType dbType;
    private Properties params = new Properties();
    private Properties dbprops = new Properties();
    private int minPoolSize = 5;
    private int maxPoolSize = 20;
    private DriverSource.Enum driverSource;
    private boolean showSQL = false;
    private boolean generateStatistics = false;

    public DatabaseConfig(DatabaseConfig dbConfig) {
        this(dbConfig.getType());
        this.dbprops = (Properties)dbConfig.getProperties().clone();
        this.minPoolSize = dbConfig.getMinPoolSize();
        this.maxPoolSize = dbConfig.getMaxPoolSize();
        this.driverSource = dbConfig.driverSource;
        this.showSQL = dbConfig.showSQL;
        this.generateStatistics = dbConfig.generateStatistics;
        this.setParams(dbConfig.getParams());
    }

    public DatabaseConfig(DBType dbType, String jdbcURL, String username, String password, DriverSource.Enum driverSource, int minPoolSize, int maxPoolSize) {
        this(dbType);
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.driverSource = driverSource;
        this.dbprops.setProperty(JDBCURL, jdbcURL);
        this.dbprops.setProperty(USERNAME, username);
        this.dbprops.setProperty(PASSWORD, password);
    }

    public DatabaseConfig(DatabaseType dbconfig) {
        this(DatabaseConfig.fromDatabaseTypeEnum(dbconfig.getType()));
        this.validateDBConfig(dbconfig);
        if (dbconfig.getParameters() != null) {
            PropertiesUtil.loadFromString(this.dbprops, dbconfig.getParameters());
            PropertiesUtil.loadFromString(this.params, dbconfig.getParameters());
        }
        if (dbconfig.getConnection().isSetDialect()) {
            this.dbprops.setProperty(DIALECT, dbconfig.getConnection().getDialect());
        } else {
            this.dbprops.setProperty(DIALECT, this.dbType.getDialect());
        }
        if (dbconfig.getConnection().isSetDriver()) {
            this.dbprops.setProperty(DRIVER, dbconfig.getConnection().getDriver());
        } else {
            this.dbprops.setProperty(DRIVER, this.dbType.getDriver());
        }
        this.dbprops.setProperty(JDBCURL, dbconfig.getConnection().getJdbcurl());
        this.dbprops.setProperty(USERNAME, dbconfig.getConnection().getUsername());
        this.dbprops.setProperty(PASSWORD, dbconfig.getConnection().getPassword());
        this.maxPoolSize = dbconfig.getConnection().isSetMaxPoolSize() ? dbconfig.getConnection().getMaxPoolSize().intValue() : 20;
        this.minPoolSize = dbconfig.getConnection().isSetMinPoolSize() ? dbconfig.getConnection().getMinPoolSize().intValue() : 5;
        if (dbconfig.getConnection().isSetDriverSource()) {
            this.driverSource = dbconfig.getConnection().getDriverSource();
        }
    }

    private void validateDBConfig(DatabaseType dbconfig) {
        if (dbconfig.getConnection() == null) {
            throw new RuntimeException("Database Configuration must provide connection information");
        }
        if (dbconfig.getConnection().getJdbcurl() == null) {
            throw new RuntimeException("The JDBC URL must be provided for the database connection");
        }
        if (dbconfig.getConnection().getUsername() == null) {
            throw new RuntimeException("The JDBC Username must be provided for the database connection");
        }
        if (dbconfig.getConnection().getPassword() == null) {
            throw new RuntimeException("The JDBC Password must be provided for the database connection");
        }
    }

    public DatabaseConfig(DBType dbType) {
        if (dbType == null) {
            throw new NullPointerException("database type must be specified");
        }
        this.dbType = dbType;
        this.dbType.applyConnectionPropsTo(this);
    }

    public Properties getProperties() {
        return this.dbprops;
    }

    public String getJdbcURL() {
        return this.dbprops.getProperty(JDBCURL);
    }

    public void setJdbcURL(String jdbcURL) {
        this.dbprops.setProperty(JDBCURL, jdbcURL);
    }

    public String getJdbcDriverClass() {
        return this.dbprops.getProperty(DRIVER);
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.dbprops.setProperty(DRIVER, jdbcDriverClass);
    }

    public String getUsername() {
        return this.dbprops.getProperty(USERNAME);
    }

    public void setUsername(String username) {
        this.dbprops.setProperty(USERNAME, username.trim());
    }

    public String getPassword() {
        return this.dbprops.getProperty(PASSWORD);
    }

    public void setPassword(String password) {
        this.dbprops.setProperty(PASSWORD, password);
    }

    public String getDialect() {
        return this.dbprops.getProperty(DIALECT);
    }

    public void setDialect(String dialect) {
        this.dbprops.setProperty(DIALECT, dialect);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setParam(String name, String value) {
        this.dbprops.setProperty(name, value);
        this.params.setProperty(name, value);
    }

    public DBType getType() {
        return this.dbType;
    }

    public void setType(String typeName) {
        this.dbType = DatabaseConfig.fromDBTypeName(typeName);
        this.setDialect(this.dbType.getDialect());
        this.setJdbcDriverClass(this.dbType.getDriver());
    }

    public String getDriverSource() {
        if (this.driverSource == null) {
            if (this.getType() == DBType.HSQL) {
                return DriverSource.BUNDLED.toString();
            }
            return DriverSource.USER.toString();
        }
        return this.driverSource.toString();
    }

    public void setDriverSource(String driverSource) {
        this.driverSource = DriverSource.Enum.forString(driverSource);
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }

    public boolean isGenerateStatistics() {
        return this.generateStatistics;
    }

    public void setShowSQL(boolean showSQL) {
        this.showSQL = showSQL;
    }

    public void setGenerateStatistics(boolean generateStatistics) {
        this.generateStatistics = generateStatistics;
    }

    public void setParams(String params) {
        for (Object key : this.params.keySet()) {
            this.dbprops.remove(key);
        }
        this.params.clear();
        PropertiesUtil.loadFromString(this.params, params);
        PropertiesUtil.loadFromString(this.dbprops, params);
    }

    public String getParams() {
        return PropertiesUtil.saveToStringSansComments(this.params);
    }

    private static DBType fromDBTypeName(String dbTypeName) {
        DBType dbType = DBType.valueOf(dbTypeName);
        if (dbType == null) {
            throw new RuntimeException("Database Type unknown: " + dbTypeName);
        }
        return dbType;
    }

    private static DBType fromDatabaseTypeEnum(DatabaseType.Type.Enum type) {
        DBType dbType = DBType.getForDatabaseType(type);
        if (dbType == null) {
            throw new RuntimeException("Database Type unknown: " + (Object)((Object)type));
        }
        return dbType;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DatabaseConfig that = (DatabaseConfig)o2;
        if (this.generateStatistics != that.generateStatistics) {
            return false;
        }
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.minPoolSize != that.minPoolSize) {
            return false;
        }
        if (this.showSQL != that.showSQL) {
            return false;
        }
        if (this.dbType != that.dbType) {
            return false;
        }
        if (this.dbprops != null ? !this.dbprops.equals(that.dbprops) : that.dbprops != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        return !(this.driverSource != null ? !((Object)((Object)this.driverSource)).equals((Object)that.driverSource) : that.driverSource != null);
    }

    public DatabaseConfig stealConnections(int howMany) {
        if (howMany <= 0) {
            throw new IllegalArgumentException("howMany must be greater than 0");
        }
        if (this.maxPoolSize <= 1) {
            throw new IllegalStateException("Can't isolate connection from a pool of max size of " + this.maxPoolSize);
        }
        int stolenPoolSize = howMany >= this.maxPoolSize ? this.maxPoolSize / 2 : (howMany <= this.maxPoolSize / 2 ? howMany : howMany / 2);
        int newMaxPoolSize = this.maxPoolSize - stolenPoolSize;
        this.setMaxPoolSize(newMaxPoolSize);
        this.setMinPoolSize(Math.min(newMaxPoolSize, this.minPoolSize));
        DatabaseConfig ret = new DatabaseConfig(this);
        ret.setMaxPoolSize(stolenPoolSize);
        ret.setMinPoolSize(stolenPoolSize);
        return ret;
    }

    public int hashCode() {
        int result = this.params != null ? this.params.hashCode() : 0;
        result = 31 * result + (this.dbprops != null ? this.dbprops.hashCode() : 0);
        result = 31 * result + (this.dbType != null ? this.dbType.hashCode() : 0);
        result = 31 * result + (this.driverSource != null ? this.driverSource.hashCode() : 0);
        result = 31 * result + this.minPoolSize;
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + (this.driverSource != null ? this.driverSource.hashCode() : 0);
        result = 31 * result + (this.showSQL ? 1 : 0);
        result = 31 * result + (this.generateStatistics ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DatabaseConfig{dbType=" + (Object)((Object)this.dbType) + ", minPoolSize=" + this.minPoolSize + ", maxPoolSize=" + this.maxPoolSize + ", showSQL=" + this.showSQL + ", generateStatistics=" + this.generateStatistics + ", driverSource=" + (Object)((Object)this.driverSource) + '}';
    }
}

