/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.jdbc.dialect.internal.StandardDialectResolver;

public enum DBType {
    HSQL("hsql", 1, DatabaseType.Type.HSQL, "org.hsqldb.jdbcDriver", "com.cenqua.crucible.hibernate.dialects.FecruHSQLDialect", "jdbc:hsqldb:%s", new Object[]{"/path/to/db"}, new String[]{"hsqldb.default_table_type=memory", "hsqldb.log_size=10", "nsql.enforce_strict_size=true"}){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) {
            return true;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitHsql();
        }

        @Override
        public void addDriverJars(FishEyeClassLoader fcl, File bundledDriverDir) throws MalformedURLException {
        }
    }
    ,
    MYSQL("MySQL", 42, DatabaseType.Type.MYSQL, "com.mysql.jdbc.Driver", "com.cenqua.crucible.hibernate.dialects.FeCruMySQL5InnoDBDialect", "jdbc:mysql://%s:%d/%s", new Object[]{"host", 3306, "dbname"}, new String[]{"useUnicode=true", "characterEncoding=UTF8", "connectionCollation=UTF8_bin"}){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            String collation = DBType.doQuery(c2, "show variables where variable_name = 'collation_database'", 2);
            if ("utf8_bin".equals(collation)) {
                return true;
            }
            Logs.APP_LOG.error((Object)("MySQL DB is using collation '" + collation + "'"));
            return false;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMySQL();
        }
    }
    ,
    ORACLE("Oracle", 71, DatabaseType.Type.ORACLE, "oracle.jdbc.OracleDriver", "com.cenqua.crucible.hibernate.dialects.OracleLargeStringsDialect", "jdbc:oracle:thin:@%s:%d:%s", new Object[]{"localhost", 1521, "dbname"}, new String[0]){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            String charset = DBType.doQuery(c2, "select value from nls_database_parameters where parameter='NLS_CHARACTERSET'", 1);
            if ("AL32UTF8".equals(charset) || "UTF8".equals(charset)) {
                return true;
            }
            Logs.APP_LOG.error((Object)("Oracle is using collation '" + charset + "'"));
            return false;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitOracle();
        }
    }
    ,
    POSTGRESQL("PostgreSQL", 42, DatabaseType.Type.POSTGRESQL, "org.postgresql.Driver", "org.hibernate.dialect.PostgreSQLDialect", "jdbc:postgresql://%s:%d/%s", new Object[]{"localhost", 5432, "dbname"}, new String[0]){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            String encoding = DBType.doQuery(c2, "show server_encoding", 1);
            if ("UTF8".equals(encoding) || "UNICODE".equals(encoding)) {
                return true;
            }
            Logs.APP_LOG.error((Object)("PostgreSQL DB is using server encoding '" + encoding + "'"));
            return false;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitPostgresSQL();
        }
    }
    ,
    SQLSERVER2005("SQLServer 2005", 72, DatabaseType.Type.SQLSERVER_2005, "net.sourceforge.jtds.jdbc.Driver", "com.cenqua.crucible.hibernate.dialects.SQLServerUnicodeDialect", "jdbc:jtds:sqlserver://%s:%d;databaseName=%s;", new Object[]{"localhost", 1433, "dbname"}, new String[0]){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            return 5.isSqlServerCollationCaseSensitive(c2);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSQLServer2005();
        }

        @Override
        public void addDriverJars(FishEyeClassLoader fcl, File bundledDriverDir) throws MalformedURLException {
            fcl.addJarsFromDir(new File(bundledDriverDir, "sqlserver"));
        }

        @Override
        public boolean isTxIsolationOptimal(Connection c2) throws SQLException {
            return 5.isReadCommittedSnapshotOn(c2);
        }
    }
    ,
    SQLSERVER2008("SQLServer 2008", 72, DatabaseType.Type.SQLSERVER_2008, "net.sourceforge.jtds.jdbc.Driver", "com.cenqua.crucible.hibernate.dialects.SQLServer2008UnicodeDialect", "jdbc:jtds:sqlserver://%s:%d;databaseName=%s;", new Object[]{"localhost", 1433, "dbname"}, new String[0]){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            return 6.isSqlServerCollationCaseSensitive(c2);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSQLServer2008();
        }

        @Override
        public void addDriverJars(FishEyeClassLoader fcl, File bundledDriverDir) throws MalformedURLException {
            fcl.addJarsFromDir(new File(bundledDriverDir, "sqlserver"));
        }

        @Override
        public boolean isTxIsolationOptimal(Connection c2) throws SQLException {
            return 6.isReadCommittedSnapshotOn(c2);
        }
    }
    ,
    SQLSERVER2012("SQLServer 2012", 72, DatabaseType.Type.SQLSERVER_2012, "net.sourceforge.jtds.jdbc.Driver", "com.cenqua.crucible.hibernate.dialects.SQLServer2008UnicodeDialect", "jdbc:jtds:sqlserver://%s:%d;databaseName=%s;", new Object[]{"localhost", 1433, "dbname"}, new String[0]){

        @Override
        public boolean isUTF8AndCaseSensitive(Connection c2) throws SQLException {
            return 7.isSqlServerCollationCaseSensitive(c2);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSQLServer2008();
        }

        @Override
        public void addDriverJars(FishEyeClassLoader fcl, File bundledDriverDir) throws MalformedURLException {
            fcl.addJarsFromDir(new File(bundledDriverDir, "sqlserver"));
        }

        @Override
        public boolean isTxIsolationOptimal(Connection c2) throws SQLException {
            return 7.isReadCommittedSnapshotOn(c2);
        }

        @Override
        public String getDdlDirectory() {
            return DatabaseType.Type.SQLSERVER_2008.toString().toUpperCase();
        }
    };

    private final String displayName;
    private final int firstDbVersion;
    private final String driver;
    private final String dialect;
    private String urlTemplate;
    private final String exampleUrl;
    private final String params;
    private final DatabaseType.Type.Enum dbConfigType;

    private DBType(String displayName, int firstDbVersion, DatabaseType.Type.Enum dbConfigType, String driver, String dialect, String urlTemplate, Object[] exampleUrlParams, String ... params) {
        this.displayName = displayName;
        this.firstDbVersion = firstDbVersion;
        this.driver = driver;
        this.dialect = dialect;
        this.urlTemplate = urlTemplate;
        this.exampleUrl = String.format(urlTemplate, exampleUrlParams);
        this.params = params == null ? "" : StringUtils.join((Object[])params, (String)"\n");
        this.dbConfigType = dbConfigType;
    }

    public abstract <T> T accept(Visitor<T> var1);

    public String toString() {
        return this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getConfigEnumName() {
        return this.dbConfigType == null ? this.getDisplayName().toLowerCase(Locale.US) : this.dbConfigType.toString();
    }

    public int getMinimalSchemaVersion() {
        return this.firstDbVersion;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getParams() {
        return this.params;
    }

    public String getUrlFromTemplate(Object ... args) {
        return String.format(this.urlTemplate, args);
    }

    public String getExampleUrl() {
        return this.exampleUrl;
    }

    public DatabaseType.Type.Enum getDbConfigType() {
        return this.dbConfigType;
    }

    public void applyConnectionPropsTo(DatabaseConfig dbConfig) {
        dbConfig.setDialect(this.getDialect());
        dbConfig.setJdbcDriverClass(this.getDriver());
        if (this.getParams() != null) {
            dbConfig.setParams(this.getParams());
        }
    }

    public static DBType getForDatabaseType(DatabaseType.Type.Enum databaseType) {
        for (DBType dbType : DBType.values()) {
            if (dbType.getDbConfigType() != databaseType) continue;
            return dbType;
        }
        return null;
    }

    public abstract boolean isUTF8AndCaseSensitive(Connection var1) throws SQLException;

    public boolean isTxIsolationOptimal(Connection c2) throws SQLException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doQuery(Connection c2, String query, int column) throws SQLException {
        String string;
        Statement s2;
        block9: {
            ResultSet rs;
            block7: {
                String string2;
                block8: {
                    s2 = null;
                    rs = null;
                    try {
                        s2 = c2.createStatement();
                        rs = s2.executeQuery(query);
                        if (!rs.next()) break block7;
                        string2 = rs.getString(column);
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            JDBCHelper.closeQuietly(rs);
                        }
                        if (s2 != null) {
                            JDBCHelper.closeQuietly(s2);
                        }
                        throw throwable;
                    }
                    JDBCHelper.closeQuietly(rs);
                }
                if (s2 != null) {
                    JDBCHelper.closeQuietly(s2);
                }
                return string2;
            }
            Logs.APP_LOG.error((Object)(query + " didn't return any rows."));
            string = null;
            if (rs == null) break block9;
            JDBCHelper.closeQuietly(rs);
        }
        if (s2 != null) {
            JDBCHelper.closeQuietly(s2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doQueryForCurrentCatalog(Connection c2, String query, int column) throws SQLException {
        String string;
        PreparedStatement ps;
        block9: {
            ResultSet rs;
            block7: {
                String string2;
                block8: {
                    ps = null;
                    rs = null;
                    String schemaName = c2.getCatalog();
                    try {
                        ps = c2.prepareStatement(query);
                        ps.setString(1, schemaName);
                        rs = ps.executeQuery();
                        if (!rs.next()) break block7;
                        string2 = rs.getString(column);
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            JDBCHelper.closeQuietly(rs);
                        }
                        if (ps != null) {
                            JDBCHelper.closeQuietly(ps);
                        }
                        throw throwable;
                    }
                    JDBCHelper.closeQuietly(rs);
                }
                if (ps != null) {
                    JDBCHelper.closeQuietly(ps);
                }
                return string2;
            }
            Logs.APP_LOG.error((Object)(query + " didn't return any rows."));
            string = null;
            if (rs == null) break block9;
            JDBCHelper.closeQuietly(rs);
        }
        if (ps != null) {
            JDBCHelper.closeQuietly(ps);
        }
        return string;
    }

    public void addDriverJars(FishEyeClassLoader fcl, File bundledDriverDir) throws MalformedURLException {
        fcl.addJarsFromDir(new File(bundledDriverDir, this.name().toLowerCase(Locale.US)));
    }

    static boolean isSqlServerCollationCaseSensitive(Connection c2) throws SQLException {
        String collation = DBType.doQueryForCurrentCatalog(c2, "select collation_name from sys.databases where name = ?", 1);
        if (collation.contains("_CS") || collation.contains("_BIN") || collation.contains("_BIN2")) {
            return true;
        }
        Logs.APP_LOG.error((Object)("SQLServer DB is using a collation which is not case sensitive: '" + collation + "'"));
        return false;
    }

    static boolean isReadCommittedSnapshotOn(Connection c2) throws SQLException {
        String txIsolation = DBType.doQueryForCurrentCatalog(c2, "select is_read_committed_snapshot_on from sys.databases where name = ?", 1);
        if ("1".equals(txIsolation)) {
            return true;
        }
        Logs.APP_LOG.error((Object)"SQLServer DB is using a default transaction isolation level which may lead to performance issues.  See https://confluence.atlassian.com/display/FISHEYE/Migrating+to+SQL+Server.");
        return false;
    }

    public String getDdlDirectory() {
        return this.getDbConfigType().toString().toUpperCase();
    }

    public static DBType fromMetadata(DatabaseMetaData databaseMetaData) throws ClassNotFoundException {
        Dialect dialect = new StandardDialectResolver().resolveDialect(databaseMetaData);
        for (DBType dbType : new DBType[]{SQLSERVER2012, SQLSERVER2008, SQLSERVER2005, POSTGRESQL, ORACLE, MYSQL, HSQL}) {
            if (!dialect.getClass().isAssignableFrom(Class.forName(dbType.getDialect()))) continue;
            return dbType;
        }
        throw new IllegalArgumentException("Can't determine dbtype");
    }

    public static abstract class VisitorAdapter<T>
    implements Visitor<T> {
        public abstract T visitDefault();

        @Override
        public T visitHsql() {
            return this.visitDefault();
        }

        @Override
        public T visitMySQL() {
            return this.visitDefault();
        }

        @Override
        public T visitPostgresSQL() {
            return this.visitDefault();
        }

        @Override
        public T visitOracle() {
            return this.visitDefault();
        }

        @Override
        public T visitSQLServer2005() {
            return this.visitDefault();
        }

        @Override
        public T visitSQLServer2008() {
            return this.visitDefault();
        }
    }

    public static interface Visitor<T> {
        public T visitHsql();

        public T visitMySQL();

        public T visitPostgresSQL();

        public T visitOracle();

        public T visitSQLServer2005();

        public T visitSQLServer2008();
    }
}

