/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.AdminOperator;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.DriverSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DBControlFactoryImpl
implements DBControlFactory {
    private DBControl currentControl = null;
    private final File instanceDir;
    private final File sqlDir;
    private String name = "default";
    private AdminOperator adminOperator = null;
    private NotificationManager notificationManager;
    private final List<String> errorMessages = new ArrayList<String>();

    public DBControlFactoryImpl() {
        this.instanceDir = AppConfig.getInstanceDir();
        this.sqlDir = new File(AppConfig.getAppHome(), "sql");
    }

    public DBControlFactoryImpl(boolean start) throws CruDBException {
        this();
        if (start) {
            this.getCurrentControl().start();
        }
    }

    public DBControlFactoryImpl(File instanceDir, File sqlDir) {
        this.instanceDir = instanceDir;
        this.sqlDir = sqlDir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public synchronized void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    @Override
    public synchronized List<String> getErrorMessages() {
        ArrayList<String> copy = new ArrayList<String>(this.errorMessages);
        this.errorMessages.clear();
        return copy;
    }

    @Override
    public synchronized DBControl getCurrentControl() {
        if (this.currentControl == null) {
            this.currentControl = this.makeControlFromDoc(AppConfig.getsConfig().getConfigDocument());
            this.currentControl.setDbControlFactory(this);
        }
        return this.currentControl;
    }

    @Override
    public synchronized void setCurrentControl(DBControl dbControl) {
        this.currentControl = dbControl;
        if (this.currentControl != null) {
            this.currentControl.setDbControlFactory(this);
        }
    }

    @Override
    public DBControl makeControl(DatabaseConfig dbConfig) {
        return DefaultDBControl.newInstance(dbConfig, this.sqlDir);
    }

    @Override
    public DBControl makeControlFromDoc(ConfigDocument config) {
        DatabaseConfig dbconfig = config != null && config.getConfig().isSetDatabase() ? new DatabaseConfig(config.getConfig().getDatabase()) : this.getDefaultDBConfig();
        return this.makeControl(dbconfig);
    }

    @Override
    public DatabaseConfig getDefaultDBConfig() {
        return new DatabaseConfig(DBType.HSQL, "jdbc:hsqldb:file:" + this.instanceDir.getAbsolutePath() + "/var/data/crudb/crucible", "sa", "", DriverSource.BUNDLED, 5, 20);
    }

    @Override
    public synchronized void setAdminOperator(AdminOperator o2) {
        this.adminOperator = o2;
    }

    @Override
    public synchronized AdminOperator getAdminOperator() {
        return this.adminOperator;
    }

    @Override
    public void changeState(boolean up) {
        if (this.notificationManager != null) {
            if (up) {
                this.notificationManager.start();
            } else {
                this.notificationManager.stop();
            }
        }
    }
}

