/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class CrowdAwareUserLoadListener
extends DefaultLoadEventListener
implements PostLoadEventListener {
    private static final Logger log = Logs.loggerFor(CrowdAwareUserLoadListener.class);
    private volatile CrowdService crowdService;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getCrowdUser(String username) {
        if (this.crowdService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.crowdService == null) {
                    this.crowdService = SpringContext.getComponent(CrowdService.class, "crowdService");
                }
            }
        }
        try {
            return this.crowdService.getUser(username);
        }
        catch (ObjectNotFoundException e2) {
            log.debug((Object)("Loading the associated crowd user with name '" + username + "' failed"), (Throwable)e2);
            return null;
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        this.setCrowdUserIfNecessary(event.getSession(), event.getEntity());
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object loaded = super.load(event, persister, keyToLoad, options);
        this.setCrowdUserIfNecessary(event.getSession(), loaded);
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCrowdUserIfNecessary(EventSource session, Object loaded) {
        String username;
        FecruUser user;
        if (loaded instanceof FecruUser && !(user = (FecruUser)loaded).isCrowdBacked() && (username = user.getUsername()) != null) {
            FlushMode flushMode = session.getFlushMode();
            try {
                session.setFlushMode(FlushMode.MANUAL);
                user.setBackingCrowdUser(this.getCrowdUser(username));
            }
            finally {
                session.setFlushMode(flushMode);
            }
        }
    }
}

