/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.BoneCPConnectionHook;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.trackingstatements.BoneCPTrackingStatementsConnectionProvider;
import com.cenqua.crucible.hibernate.trackingstatements.HibernateBonceCPConnectionProvider;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class Config {
    private static boolean DISABLE_HIBERNATE_CACHING = false;
    private static boolean DISABLE_HIBERNATE_BATCHING = false;
    private static Map<Pair<Class, String>, Integer> fieldLengths;
    private static final int TEXT_FIELD_SIZE = 0xFFFFFF;
    public static final int BONECP_PARTITION_COUNT_DEFAULT = 3;
    public static final String BONECP_PARTITION_COUNT = "bonecp.partitionCount";
    public static final String BONECP_MIN_CONNECTIONS_PER_PARTITION = "bonecp.minConnectionsPerPartition";
    public static final String BONECP_MAX_CONNECTIONS_PER_PARTITION = "bonecp.maxConnectionsPerPartition";
    public static final String BONECP_ACQUIRE_INCREMENT = "bonecp.acquireIncrement";
    public static final String BONECP_STATEMENTS_CACHE_SIZE = "bonecp.statementsCacheSize";
    public static final String BONECP_RELEASE_HELPER_THREADS = "bonecp.releaseHelperThreads";
    public static final String BONECP_IDLE_MAX_AGE = "bonecp.idleMaxAgeInMinutes";
    public static final String BONECP_IDLE_CONNECTION_TEST_PERIOD = "bonecp.idleConnectionTestPeriodInMinutes";
    public static final String BONECP_POOL_NAME = "bonecp.poolName";
    public static final String BONECP_CONNECTION_HOOK_CLASS_NAME = "bonecp.connectionHookClassName";
    public static final String BONECP_TRACK_STATEMENTS = "bonecp.trackStatements";
    public static final String BONECP_DETECT_UNCLOSED_STATEMENTS = "bonecp.detectUnclosedStatements";
    public static final String[] HIBERNATE_MAPPING_FILES;

    private static boolean getProp(String type, String prop) {
        boolean val = Boolean.getBoolean(prop);
        if (val) {
            String msg = "Hibernate " + type + " has been disabled via property " + prop;
            Logs.APP_LOG.warn((Object)msg);
        }
        return val;
    }

    public static Configuration addResources(Configuration cfg) {
        for (String fileName : HIBERNATE_MAPPING_FILES) {
            cfg.addResource(fileName);
        }
        return cfg;
    }

    public static Configuration getConfig(DatabaseConfig dbConfig, String poolName) {
        return Config.getConfig(dbConfig, null, true, poolName);
    }

    public static Configuration getConfig(DatabaseConfig dbConfig, Integer partitionsCount, boolean enableCaching, String poolName) {
        Configuration cfg = new Configuration();
        Config.addResources(cfg);
        if (DISABLE_HIBERNATE_BATCHING) {
            cfg.setProperty("hibernate.jdbc.batch_size", "0");
        }
        cfg.setProperty("hibernate.connection.autocommit", "false");
        cfg.setProperty("hibernate.connection.driver_class", dbConfig.getJdbcDriverClass());
        cfg.setProperty("hibernate.connection.url", dbConfig.getJdbcURL());
        cfg.setProperty("hibernate.connection.username", dbConfig.getUsername());
        cfg.setProperty("hibernate.connection.password", dbConfig.getPassword());
        cfg.setProperty("hibernate.dialect", dbConfig.getDialect());
        Config.setUpStatementTracking(dbConfig, poolName, cfg);
        int boneCpPartitionsCount = partitionsCount == null ? NumberUtils.toInt((String)dbConfig.getProperties().getProperty(BONECP_PARTITION_COUNT), (int)3) : partitionsCount;
        dbConfig.getProperties().put(BONECP_PARTITION_COUNT, boneCpPartitionsCount + "");
        int minPerPartition = dbConfig.getMinPoolSize() / boneCpPartitionsCount;
        minPerPartition = minPerPartition < 1 ? 1 : minPerPartition;
        int maxPerPartition = dbConfig.getMaxPoolSize() / boneCpPartitionsCount;
        maxPerPartition = maxPerPartition < 1 ? 1 : maxPerPartition;
        cfg.setProperty(BONECP_IDLE_MAX_AGE, "0");
        cfg.setProperty(BONECP_IDLE_CONNECTION_TEST_PERIOD, "60");
        cfg.setProperty(BONECP_PARTITION_COUNT, boneCpPartitionsCount + "");
        cfg.setProperty(BONECP_ACQUIRE_INCREMENT, "2");
        cfg.setProperty(BONECP_MAX_CONNECTIONS_PER_PARTITION, maxPerPartition + "");
        cfg.setProperty(BONECP_MIN_CONNECTIONS_PER_PARTITION, minPerPartition + "");
        cfg.setProperty(BONECP_STATEMENTS_CACHE_SIZE, "50");
        cfg.setProperty(BONECP_RELEASE_HELPER_THREADS, "3");
        cfg.setProperty(BONECP_POOL_NAME, poolName);
        cfg.setProperty(BONECP_CONNECTION_HOOK_CLASS_NAME, BoneCPConnectionHook.class.getName());
        cfg.setProperty("hibernate.show_sql", Boolean.toString(dbConfig.isShowSQL()));
        cfg.setProperty("hibernate.generate_statistics", Boolean.toString(dbConfig.isGenerateStatistics()));
        cfg.setProperty("net.sf.ehcache.configurationResourceName", "ehcache.xml");
        cfg.setProperty("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory");
        if (!DISABLE_HIBERNATE_CACHING && enableCaching) {
            cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
            cfg.setProperty("hibernate.cache.use_query_cache", "true");
        } else {
            cfg.setProperty("hibernate.cache.use_second_level_cache", "false");
            cfg.setProperty("hibernate.cache.use_query_cache", "false");
        }
        cfg.setProperty("hibernate.connection.isolation", Integer.toString(2));
        cfg.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        cfg.buildMappings();
        fieldLengths = Config.recordFieldLengths(cfg);
        if (DBType.ORACLE.equals((Object)dbConfig.getType())) {
            cfg.setProperty("hibernate.jdbc.batch_size", "0");
            cfg.setProperty(BONECP_STATEMENTS_CACHE_SIZE, "0");
            cfg.setProperty("hibernate.dbcp.ps.maxIdle", "0");
        }
        cfg.addProperties(dbConfig.getProperties());
        return cfg;
    }

    private static void setUpStatementTracking(DatabaseConfig dbConfig, String poolName, Configuration cfg) {
        boolean boneCpTrackStatements = Boolean.parseBoolean(dbConfig.getProperties().getProperty(BONECP_TRACK_STATEMENTS, "true"));
        if (boneCpTrackStatements) {
            Logs.APP_LOG.info((Object)String.format("BoneCP - tracking statements enabled for pool [%s]", poolName));
            boolean boneCpDetectUnclosedStatements = Boolean.parseBoolean(dbConfig.getProperties().getProperty(BONECP_DETECT_UNCLOSED_STATEMENTS, "false"));
            if (boneCpDetectUnclosedStatements) {
                Logs.APP_LOG.info((Object)String.format("BoneCP - detecting unclosed statements enabled for pool [%s]", poolName));
                BoneCPTrackingStatementsConnectionProvider.detectUnclosedStatements();
            }
            cfg.setProperty("hibernate.connection.provider_class", BoneCPTrackingStatementsConnectionProvider.class.getName());
        } else {
            Logs.APP_LOG.info((Object)String.format("BoneCP - tracking statements disabled for pool [%s]", poolName));
            cfg.setProperty("hibernate.connection.provider_class", HibernateBonceCPConnectionProvider.class.getName());
        }
    }

    private static Map<Pair<Class, String>, Integer> recordFieldLengths(Configuration cfg) {
        HashMap sizes = Maps.newHashMap();
        Iterator iter = cfg.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass persistentClass;
            Class mappedClass = persistentClass.getMappedClass();
            for (persistentClass = (PersistentClass)iter.next(); persistentClass != null; persistentClass = persistentClass.getSuperclass()) {
                Iterator iter2 = persistentClass.getPropertyIterator();
                while (iter2.hasNext()) {
                    int length;
                    Property property = (Property)iter2.next();
                    Iterator columnIterator = property.getColumnIterator();
                    if (!columnIterator.hasNext() || (length = ((Column)columnIterator.next()).getLength()) >= 0xFFFFFF) continue;
                    sizes.put(Pair.newInstance(mappedClass, property.getName()), length);
                }
            }
        }
        return sizes;
    }

    public static Integer getLength(Class clazz, String field) {
        if (fieldLengths == null) {
            throw new IllegalStateException("Hibernate has not been configured");
        }
        return fieldLengths.get(Pair.newInstance(clazz, field));
    }

    static {
        DISABLE_HIBERNATE_CACHING = Config.getProp("caching", "crucible.hibernate.caching.disabled");
        DISABLE_HIBERNATE_BATCHING = Config.getProp("batching", "crucible.hibernate.batching.disabled");
        HIBERNATE_MAPPING_FILES = new String[]{"com/cenqua/crucible/model/FileRevisionExtraInfo.hbm.xml", "com/cenqua/crucible/model/PermissionScheme.hbm.xml", "com/cenqua/crucible/model/principalAssociations/AllUser.hbm.xml", "com/cenqua/crucible/model/principalAssociations/Role.hbm.xml", "com/cenqua/crucible/model/principalAssociations/Anonymous.hbm.xml", "com/cenqua/crucible/model/principalAssociations/User.hbm.xml", "com/cenqua/crucible/model/principalAssociations/Group.hbm.xml", "com/cenqua/crucible/model/Project.hbm.xml", "com/cenqua/crucible/model/StateChangeLog.hbm.xml", "com/cenqua/crucible/model/ReviewPermaId.hbm.xml", "com/atlassian/fecru/user/FecruUser.hbm.xml", "com/atlassian/fecru/user/UserProfile.hbm.xml", "com/cenqua/crucible/model/Review.hbm.xml", "com/cenqua/crucible/model/CrucibleRevision.hbm.xml", "com/cenqua/crucible/model/FRXRevision.hbm.xml", "com/cenqua/crucible/model/Comment.hbm.xml", "com/cenqua/crucible/model/Patch.hbm.xml", "com/cenqua/crucible/model/CommentReadStatus.hbm.xml", "com/cenqua/crucible/model/FileReadStatus.hbm.xml", "com/cenqua/crucible/model/StoredPath.hbm.xml", "com/cenqua/crucible/model/InlineComment.hbm.xml", "com/cenqua/crucible/model/InlineCommentRevisionDetail.hbm.xml", "com/cenqua/crucible/model/FRXComment.hbm.xml", "com/cenqua/crucible/model/ReviewParticipant.hbm.xml", "com/cenqua/crucible/model/ReviewProperty.hbm.xml", "com/cenqua/crucible/model/CustomField.hbm.xml", "com/cenqua/crucible/model/LogItem.hbm.xml", "com/cenqua/crucible/model/CrucibleActivityItem.hbm.xml", "com/atlassian/crucible/configuration/metrics/MetricsConfigDef.hbm.xml", "com/cenqua/crucible/upload/UploadItem.hbm.xml", "com/atlassian/crucible/fisheye/CrucibleReindexMessage.hbm.xml", "com/cenqua/crucible/hibernate/DbVersion.hbm.xml", "com/cenqua/crucible/notification/Recipient.hbm.xml", "com/cenqua/crucible/notification/NotificationStore.hbm.xml", "com/cenqua/fisheye/model/CommitterUserMapping.hbm.xml", "com/atlassian/fisheye/stars/model/BaseStarModel.hbm.xml", "com/atlassian/fisheye/user/model/RecentlyVisitedItem.hbm.xml", "com/cenqua/fisheye/model/ContentRoot.hbm.xml", "com/atlassian/fisheye/model/ChangesetComment.hbm.xml", "com/cenqua/crucible/model/UserAppLink.hbm.xml", "com/atlassian/fecru/properties/UserRepositoryProperty.hbm.xml", "com/atlassian/fecru/properties/RepositoryProperty.hbm.xml", "com/cenqua/fisheye/web/Watch.hbm.xml", "com/cenqua/fisheye/rep/CommitNotification.hbm.xml", "com/atlassian/fecru/user/LoginCookie.hbm.xml", "com/atlassian/fecru/usersettings/UserSetting.hbm.xml", "com/atlassian/fisheye/user/permissions/model/GlobalPermission.hbm.xml", "com/atlassian/fecru/user/crowd/model/CustomTypes.hbm.xml", "com/atlassian/fecru/user/crowd/model/InternalMembership.hbm.xml", "com/atlassian/fecru/user/crowd/model/InternalGroup.hbm.xml", "com/atlassian/fecru/user/crowd/model/Directory.hbm.xml", "com/atlassian/fecru/user/crowd/model/InternalUser.hbm.xml", "com/atlassian/fecru/user/crowd/model/Application.hbm.xml", "com/atlassian/fecru/user/crowd/model/Alias.hbm.xml", "com/atlassian/fecru/user/crowd/model/Webhook.hbm.xml", "com/atlassian/fecru/user/crowd/model/Token.hbm.xml", "com/atlassian/fecru/user/crowd/model/ExpirableUserToken.hbm.xml", "com/atlassian/fecru/user/crowd/model/Property.hbm.xml", "com/atlassian/fecru/user/crowd/model/InternalGrantedPermission.hbm.xml"};
    }
}

